---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：34-llvm-split

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な測定データなし

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-split/llvm-split.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-splitはLLVMモジュールを分割するツールである | E-01 1-12行目コメント | ○ |
| C-02 | 入力ファイルはデフォルトで標準入力("-") | E-01 43-47行目 InputFilename定義 | ○ |
| C-03 | -jで出力ファイル数を指定（デフォルト: 2） | E-01 54-56行目 NumOutputs定義 | ○ |
| C-04 | -preserve-localsでローカルシンボルを外部化せずに分割 | E-01 58-61行目 PreserveLocals定義 | ○ |
| C-05 | -round-robinでラウンドロビン分配を使用 | E-01 63-67行目 RoundRobin定義 | ○ |
| C-06 | -mtripleでターゲットトリプルを指定 | E-01 69-74行目 MTriple定義 | ○ |
| C-07 | -mcpuでターゲットCPUを指定 | E-01 76-78行目 MCPU定義 | ○ |
| C-08 | SplitByCategoryTypeでカテゴリ分割タイプを定義 | E-01 80-84行目 enum定義 | ○ |
| C-09 | -split-by-categoryでカテゴリ別分割を指定 | E-01 86-96行目 SplitByCategory定義 | ○ |
| C-10 | -Sでアセンブリ出力 | E-01 98-99行目 OutputAssembly定義 | ○ |
| C-11 | writeModuleToFile関数でモジュールをファイル出力 | E-01 113-126行目 writeModuleToFile | ○ |
| C-12 | EntryPointCategorizerでカテゴリ判定 | E-01 134-203行目 EntryPointCategorizer定義 | ○ |
| C-13 | isEntryPointでSPIR/AMDGPU/PTXカーネルを判定 | E-01 159-166行目 isEntryPoint | ○ |
| C-14 | cleanupModuleでGlobalDCEパスを実行 | E-01 205-211行目 cleanupModule | ○ |
| C-15 | runSplitModuleByCategoryでカテゴリ別分割を実行 | E-01 213-236行目 runSplitModuleByCategory | ○ |
| C-16 | main関数がエントリーポイント | E-01 238-323行目 main関数 | ○ |
| C-17 | ターゲット初期化時にInitializeAllTargetsを呼び出し | E-01 250行目 InitializeAllTargets | ○ |
| C-18 | parseIRFileで入力モジュールを読み込み | E-01 265行目 parseIRFile | ○ |
| C-19 | TargetMachine::splitModule失敗時にフォールバック | E-01 316-318行目 警告メッセージ | ○ |
| C-20 | SplitModule関数がデフォルトの分割処理 | E-01 321行目 SplitModule呼び出し | ○ |
| C-21 | HandleModulePartでverifyModuleを実行 | E-01 282-285行目 verifyModule | ○ |
| C-22 | 関数数に比例した処理時間 | **根拠なし**（測定データなし） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス測定データ
  - 候補：ベンチマーク結果 / 処理時間測定データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能・オプションの記述（C-01〜C-21）
- 1: 低リスク - パフォーマンスの記述（C-22）

## 6) レビュアーチェックリスト（最小）
- [ ] 各オプションの動作がソースコードと一致しているか確認
- [ ] カテゴリ分割のエントリポイント判定条件が正しいか確認
- [ ] ターゲット固有分割のフォールバック動作が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか確認
