---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-llvm-extract

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：遅延ロードの効果測定データなし

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-extract/llvm-extract.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-extractは関数/グローバル変数を抽出するツールである | E-01 1-12行目コメント | ○ |
| C-02 | 入力ファイルはデフォルトで標準入力("-") | E-01 47-50行目 InputFilename定義 | ○ |
| C-03 | -oで出力ファイル指定（デフォルト: "-"） | E-01 52-55行目 OutputFilename定義 | ○ |
| C-04 | -fでターミナルへのバイナリ出力を許可 | E-01 57-58行目 Force定義 | ○ |
| C-05 | -deleteで指定グローバル値を削除 | E-01 60-62行目 DeleteFn定義 | ○ |
| C-06 | -keep-const-initで定数の初期化子を保持 | E-01 64-66行目 KeepConstInit定義 | ○ |
| C-07 | -recursiveで再帰的に関数を抽出 | E-01 68-70行目 Recursive定義 | ○ |
| C-08 | -funcで関数名を指定して抽出 | E-01 73-75行目 ExtractFuncs定義 | ○ |
| C-09 | -rfuncで正規表現により関数を抽出 | E-01 79-83行目 ExtractRegExpFuncs定義 | ○ |
| C-10 | -bbで基本ブロックを指定して抽出 | E-01 86-100行目 ExtractBlocks定義 | ○ |
| C-11 | -aliasでエイリアス名を指定して抽出 | E-01 103-105行目 ExtractAliases定義 | ○ |
| C-12 | -raliasで正規表現によりエイリアスを抽出 | E-01 109-113行目 ExtractRegExpAliases定義 | ○ |
| C-13 | -globでグローバル変数名を指定して抽出 | E-01 116-118行目 ExtractGlobals定義 | ○ |
| C-14 | -rglobで正規表現によりグローバル変数を抽出 | E-01 122-126行目 ExtractRegExpGlobals定義 | ○ |
| C-15 | -SでLLVM IRアセンブリとして出力 | E-01 128-130行目 OutputAssembly定義 | ○ |
| C-16 | getLazyIRFileModuleで遅延ロード | E-01 141行目 getLazyIRFileModule | ○ |
| C-17 | SetVectorで重複排除 | E-01 149行目 SetVector<GlobalValue*> | ○ |
| C-18 | Regexで正規表現マッチング | E-01 165行目 Regex構築 | ○ |
| C-19 | -recursive時にCallBase命令を走査 | E-01 287-290行目 CallBase検出 | ○ |
| C-20 | ExtractGVPassでグローバル値抽出 | E-01 332行目 ExtractGVPass | ○ |
| C-21 | BlockExtractorPassで基本ブロック抽出 | E-01 379行目 BlockExtractorPass | ○ |
| C-22 | GlobalDCEPassで到達不能グローバル削除 | E-01 401行目 GlobalDCEPass | ○ |
| C-23 | StripDeadDebugInfoPassでデバッグ情報削除 | E-01 402行目 StripDeadDebugInfoPass | ○ |
| C-24 | 遅延ロードによるメモリ効率化 | **根拠なし**（効果測定データなし） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス効果の定量的データ
  - 候補：メモリ使用量測定データ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能・オプションの記述（C-01〜C-23）
- 1: 低リスク - パフォーマンスの記述（C-24）

## 6) レビュアーチェックリスト（最小）
- [ ] 各オプションの動作がソースコードと一致しているか確認
- [ ] 正規表現マッチングの動作が正しいか確認
- [ ] 再帰抽出処理のCallBase検出が正しいか確認
- [ ] 各パスの実行順序が正しいか確認
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか確認
