---
generated_at: 2026-02-01 22:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-opt.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/opt/opt.cpp` - optエントリーポイント（28行）
- E-02: `llvm/tools/opt/optdriver.cpp` - optメインドライバ（949行）
- E-03: `llvm/tools/opt/NewPMDriver.cpp` - 新パスマネージャドライバ
- E-04: `機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | optはLLVM IRに最適化パスを適用するツール | E-02 (8-12行目), E-04 | ○ |
| C-02 | optMainでメイン処理実行 | E-02 (406-948行目) | ○ |
| C-03 | -passesでパスパイプライン指定 | E-02 (87-94行目) | ○ |
| C-04 | -O0〜-O3で最適化レベル指定 | E-02 (163-186行目) | ○ |
| C-05 | -Sでアセンブリ出力 | E-02 (118-119行目) | ○ |
| C-06 | -print-passesでパス一覧表示 | E-02 (99-101行目, 493-496行目) | ○ |
| C-07 | parseIRFileでIR読み込み | E-02 (559行目) | ○ |
| C-08 | 新パスマネージャがデフォルト | E-02 (472-473行目) | ○ |
| C-09 | -passesと-Oは排他的 | E-02 (724-728行目) | ○ |
| C-10 | runPassPipelineで新PM処理実行 | E-02 (758-765行目) | ○ |
| C-11 | DebugifyCustomPassManagerでレガシーPM処理 | E-02 (789行目) | ○ |
| C-12 | -verify-eachで各パス後検証 | E-02 (147-148行目) | ○ |
| C-13 | -disable-outputで出力抑制 | E-02 (113-116行目) | ○ |
| C-14 | -run-twiceで2回実行比較 | E-02 (238-241行目) | ○ |
| C-15 | time-traceで時間プロファイリング | E-02 (248-259行目) | ○ |
| C-16 | InitializeAllTargetsで全ターゲット初期化 | E-02 (414-417行目) | ○ |
| C-17 | PassBuilderでパイプライン構築 | E-03 | ○ |
| C-18 | ModulePassManager::runでパス実行 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: すべての主張が根拠に基づいており、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] optdriver.cpp の行番号参照が最新のコードと一致するか確認
- [ ] 新パスマネージャとレガシーパスマネージャの分岐条件が正確か確認
- [ ] -passesオプションの構文が最新のドキュメントと一致するか確認
