---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：41-llvm-profdata

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数GB処理能力**：具体的なテスト結果なし
  2. **時系列順序計算のアルゴリズム詳細**：ソースコード詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 57-77行目（サブコマンド定義）
- E-02: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 79-93行目（ProfileKinds/ProfileFormat）
- E-03: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 95-106行目（共通オプション）
- E-04: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 168-189行目（入力ファイルオプション）
- E-05: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 200-234行目（マージオプション）
- E-06: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 282-299行目（FailureMode）
- E-07: `llvm/tools/llvm-profdata/llvm-profdata.cpp` 386-446行目（showオプション）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 42行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのサブコマンド（merge/show/overlap/order）を提供 | E-01 | ○ |
| C-02 | ProfileKinds: instr/sample/memoryの3種類 | E-02 | ○ |
| C-03 | ProfileFormat: Text/Binary/ExtBinary/GCC | E-02 | ○ |
| C-04 | OutputFilename共通オプション | E-03 | ○ |
| C-05 | weighted-inputオプションによる重み付けマージ | E-04 | ○ |
| C-06 | MD5オプションによる関数名ハッシュ化 | E-05 | ○ |
| C-07 | CompressAllSectionsオプション | E-05 | ○ |
| C-08 | FailureMode: warnOnly/failIfAnyAreInvalid/failIfAllAreInvalid | E-06 | ○ |
| C-09 | ShowFormat: Text/Json/Yaml | E-07 | ○ |
| C-10 | プロファイルデータ操作ツール | E-08 | ○ |
| C-11 | 複数スレッド並列マージ対応（-num-threads） | E-05 | ○ |
| C-12 | サンプルプロファイルマージ機能 | E-05 | ○ |
| C-13 | コンテキストプロファイルのコールドマージ | E-05 | ○ |
| C-14 | Temporal Profile Trace対応 | E-05 | ○ |
| C-15 | debuginfod連携機能 | E-04 | ○ |
| C-16 | InstrProfCorrelator対応 | E-04 | ○ |
| C-17 | 数GBの大規模プロファイル処理能力 | **根拠なし** | △ |
| C-18 | ページフォールト最小化アルゴリズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的なベンチマーク結果
  - 候補：LLVMのテストスイート / パフォーマンステスト結果
- order サブコマンドの詳細アルゴリズム仕様
  - 候補：llvm-profdata.cppのorderMain関数詳細 / LLVMドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能の説明は正確
- 1: 中リスク - パフォーマンス要件は実測確認推奨
- 0: 低リスク - オプション仕様はソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] サブコマンドの説明が最新バージョンと一致しているか
- [ ] オプションの説明が実装と一致しているか
- [ ] パフォーマンス要件の妥当性確認
- [ ] エラーハンドリングの網羅性確認
