---
generated_at: 2026-02-01 22:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：48-llvm-mca

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Intel IACAとの機能比較詳細**：比較検証結果未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-mca/llvm-mca.cpp` 68-69行目（カテゴリ定義）
- E-02: `llvm/tools/llvm-mca/llvm-mca.cpp` 71-98行目（基本オプション）
- E-03: `llvm/tools/llvm-mca/llvm-mca.cpp` 113-141行目（シミュレーションオプション）
- E-04: `llvm/tools/llvm-mca/llvm-mca.cpp` 172-265行目（ビューオプション）
- E-05: `llvm/tools/llvm-mca/llvm-mca.cpp` 362-381行目（main関数）
- E-06: `llvm/tools/llvm-mca/llvm-mca.cpp` 627-731行目（パイプライン処理）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -mcpuでターゲットCPU指定、デフォルトnative | E-02 | ○ |
| C-02 | -mtripleでターゲットトリプル指定 | E-02 | ○ |
| C-03 | -marchでターゲットアーキテクチャ指定 | E-02 | ○ |
| C-04 | -iterationsで反復回数指定 | E-03 | ○ |
| C-05 | -oで出力ファイル指定 | E-02 | ○ |
| C-06 | --jsonでJSON形式出力 | E-02 | ○ |
| C-07 | --timelineでタイムラインビュー有効化 | E-04 | ○ |
| C-08 | --resource-pressureでリソース圧力ビュー有効化 | E-04 | ○ |
| C-09 | --bottleneck-analysisでボトルネック分析有効化 | E-04 | ○ |
| C-10 | --instruction-tablesで命令テーブルモード | E-04 | ○ |
| C-11 | InstrSchedModel必須 | E-05 | ○ |
| C-12 | LLVM-MCA-BEGIN/ENDマーカー対応 | E-06 | ○ |
| C-13 | Machine Code Analyzer - パイプラインシミュレーションツール | E-07 | ○ |
| C-14 | --skip-unsupported-instructionsで未対応命令スキップ | E-04 | ○ |
| C-15 | サマリービュー（IPC、サイクル数） | E-04 | ○ |
| C-16 | 命令情報ビュー（レイテンシ、スループット） | E-04 | ○ |
| C-17 | ディスパッチ/スケジューラ統計 | E-04 | ○ |
| C-18 | Intel IACAと同等機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Intel IACAとの機能比較詳細
  - 候補：LLVMドキュメント / ベンチマーク比較結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - オプション仕様はソースコードと完全整合
- 0: 低リスク - ビュー種類の説明は正確
- 1: 中リスク - IACA比較の正確性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] オプションの説明が最新バージョンと一致しているか
- [ ] ビュー種類の説明が正確か
- [ ] ボトルネック分析の説明が十分か
- [ ] サポートCPU/アーキテクチャの説明が適切か
