---
generated_at: 2026-02-01 22:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：49-llvm-exegesis

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **サポートアーキテクチャの詳細**：ARMサポート状況未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 53-66行目（オペコードオプション）
- E-02: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 68-73行目（BenchmarkFileオプション）
- E-03: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 75-83行目（BenchmarkMode列挙型）
- E-04: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 85-94行目（ResultAggregationMode）
- E-05: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 96-108行目（RepetitionMode）
- E-06: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 115-136行目（BenchmarkPhaseSelector）
- E-07: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 138-142行目（UseDummyPerfCounters）
- E-08: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 246-257行目（ExecutionMode）
- E-09: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 306-317行目（getOpcodesOrDie入力検証）
- E-10: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 467-583行目（benchmarkMain）
- E-11: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 624-696行目（analysisMain）
- E-12: `llvm/tools/llvm-exegesis/llvm-exegesis.cpp` 701-738行目（main関数）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 50行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -mode: latency/inverse_throughput/uops/analysis | E-03 | ○ |
| C-02 | -opcode-indexでオペコードインデックス指定 | E-01 | ○ |
| C-03 | -opcode-nameで命令名指定（カンマ区切り） | E-01 | ○ |
| C-04 | -snippets-fileでカスタムスニペット指定 | E-01 | ○ |
| C-05 | -benchmarks-fileで結果ファイル指定 | E-02 | ○ |
| C-06 | 入力指定は排他的（1つのみ） | E-09 | ○ |
| C-07 | -result-aggregation-modeで集約方法指定 | E-04 | ○ |
| C-08 | -repetition-modeで反復方法指定 | E-05 | ○ |
| C-09 | -benchmark-phaseで実行フェーズ制御 | E-06 | ○ |
| C-10 | --use-dummy-perf-countersでダミーカウンタ使用 | E-07 | ○ |
| C-11 | -execution-mode: inprocess/subprocess | E-08 | ○ |
| C-12 | libpfmがない場合のエラーメッセージ | E-10 | ○ |
| C-13 | benchmarkMain()でベンチマーク処理 | E-10 | ○ |
| C-14 | analysisMain()で分析処理 | E-11 | ○ |
| C-15 | BenchmarkClustering::createでクラスタリング | E-11 | ○ |
| C-16 | 分析は単一CPU/トリプルのデータのみ対応 | E-11 | ○ |
| C-17 | 命令レベルのベンチマーク/分析ツール | E-13 | ○ |
| C-18 | Intel/AMD x86、ARMサポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サポートアーキテクチャの詳細リスト
  - 候補：TargetExegesis.defまたはLLVMドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モード定義はソースコードと完全整合
- 0: 低リスク - オプション仕様の説明は正確
- 1: 中リスク - サポートアーキテクチャの網羅性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] BenchmarkMode列挙型の値が最新か
- [ ] ExecutionModeの説明が正確か
- [ ] libpfm依存の説明が十分か
- [ ] クラスタリングアルゴリズムの説明が適切か
