---
generated_at: 2026-02-01 22:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：50-llvm-xray

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **FDRトレース形式の詳細**：FDR（Flight Data Recorder）形式の仕様未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-xray/llvm-xray.cpp` 25-48行目（main関数）
- E-02: `llvm/tools/llvm-xray/xray-registry.h` 18-36行目（CommandRegistration）
- E-03: `llvm/tools/llvm-xray/xray-account.cpp` 31-34行目（Accountサブコマンド）
- E-04: `llvm/tools/llvm-xray/xray-account.cpp` 56-65行目（AccountOutputFormat）
- E-05: `llvm/tools/llvm-xray/xray-account.cpp` 67-90行目（SortField列挙型）
- E-06: `llvm/tools/llvm-xray/xray-account.cpp` 106-110行目（AccountTopオプション）
- E-07: `llvm/tools/llvm-xray/xray-account.cpp` 160-257行目（accountRecord）
- E-08: `llvm/tools/llvm-xray/xray-converter.cpp` 32-35行目（Convertサブコマンド）
- E-09: `llvm/tools/llvm-xray/xray-converter.cpp` 36-44行目（ConvertFormats）
- E-10: `llvm/tools/llvm-xray/xray-converter.cpp` 54-59行目（symbolizeオプション）
- E-11: `llvm/tools/llvm-xray/xray-converter.cpp` 274-365行目（Chrome Trace Event出力）
- E-12: `llvm/tools/llvm-xray/xray-graph.cpp` 26-29行目（graphサブコマンド）
- E-13: `llvm/tools/llvm-xray/xray-stacks.cpp` 36-39行目（stackサブコマンド）
- E-14: `llvm/tools/llvm-xray/xray-stacks.cpp` 77-89行目（StackOutputFormat）
- E-15: `llvm/tools/llvm-xray/xray-extract.cpp` 32-35行目（extractサブコマンド）
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 51行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サブコマンドベースのディスパッチ構造 | E-01, E-02 | ○ |
| C-02 | accountサブコマンドで関数統計 | E-03 | ○ |
| C-03 | account -format: text/csv | E-04 | ○ |
| C-04 | account -sort: funcid/count/min/med/90p/99p/max/sum | E-05 | ○ |
| C-05 | account -topで上位N件表示 | E-06 | ○ |
| C-06 | LatencyAccountant::accountRecord()で統計処理 | E-07 | ○ |
| C-07 | convertサブコマンドで形式変換 | E-08 | ○ |
| C-08 | convert -output-format: raw/yaml/trace_event | E-09 | ○ |
| C-09 | convert -symbolizeでシンボル化 | E-10 | ○ |
| C-10 | Chrome Trace Viewer形式出力対応 | E-11 | ○ |
| C-11 | graphサブコマンドでDOT出力 | E-12 | ○ |
| C-12 | stackサブコマンドでスタック分析 | E-13 | ○ |
| C-13 | stack -stack-format: human/flame | E-14 | ○ |
| C-14 | FlameGraph形式出力対応 | E-14 | ○ |
| C-15 | extractサブコマンドで計装マップ抽出 | E-15 | ○ |
| C-16 | -instr_mapで計装マップ指定 | E-03 | ○ |
| C-17 | -deduce-sibling-callsで兄弟呼び出し推定 | E-07 | ○ |
| C-18 | XRayトレースデータの解析ツール | E-16 | ○ |
| C-19 | パーセンタイル計算（nth_element使用） | E-07 | ○ |
| C-20 | FDRトレース形式のダンプ機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FDR（Flight Data Recorder）トレース形式の詳細仕様
  - 候補：xray-fdr-dump.cpp / LLVMドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サブコマンド定義はソースコードと完全整合
- 0: 低リスク - 出力形式オプションの説明は正確
- 1: 中リスク - FDRトレース形式の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] サブコマンドの一覧が最新バージョンと一致しているか
- [ ] accountサブコマンドの統計フィールドが正確か
- [ ] convert出力形式の説明が十分か
- [ ] Chrome Trace Viewer形式の互換性説明が適切か
- [ ] FlameGraph形式の出力仕様が正確か
