---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-llvm-undname

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **MicrosoftDemangle.cppの詳細実装**：本体は別ファイル
  2. **MSDemangleFlagsの全フラグ**：Demangle.hで確認

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-undname/llvm-undname.cpp` （メインソースコード）
- E-02: `llvm/tools/llvm-undname/CMakeLists.txt` （ビルド設定）
- E-03: 機能一覧.csv No.58 エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Microsoftマングル名をデマングル | E-01 (9-12行目コメント) | ○ |
| C-02 | Windows undnameと互換 | E-01 (10行目コメント) | ○ |
| C-03 | 引数または標準入力からシンボル取得 | E-01 (114-146行目) | ○ |
| C-04 | --raw-fileでファイル入力 | E-01 (54-56行目, 102-111行目) | ○ |
| C-05 | --backrefsでバックリファレンスダンプ | E-01 (33-36行目) | ○ |
| C-06 | --no-access-specifier | E-01 (37-40行目) | ○ |
| C-07 | --no-calling-convention | E-01 (41-44行目) | ○ |
| C-08 | --no-return-type | E-01 (45-47行目) | ○ |
| C-09 | --no-member-type | E-01 (48-50行目) | ○ |
| C-10 | --no-variable-type | E-01 (51-53行目) | ○ |
| C-11 | --warn-trailingで末尾文字警告 | E-01 (57-60行目, 86-88行目) | ○ |
| C-12 | 空行・コメントスキップ | E-01 (123行目) | ○ |
| C-13 | リダイレクト入力時エコー | E-01 (130-132行目) | ○ |
| C-14 | microsoftDemangle()使用 | E-01 (82行目) | ○ |
| C-15 | MSDemangleFlagsでフィルタリング | E-01 (67-79行目) | ○ |
| C-16 | 失敗時エラーメッセージ | E-01 (89-91行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要機能はすべて根拠付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張が根拠付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] オプションの説明がcl::optと一致しているか確認
- [ ] msDemangle関数の処理順序が記述と一致しているか確認
- [ ] MSDemangleFlagsの設定が正しいか確認
