---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：61-llvm-mt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-mt/llvm-mt.cpp` - メインソースコード
- E-02: `llvm/tools/llvm-mt/Opts.td` - コマンドラインオプション定義
- E-03: `llvm/tools/llvm-mt/CMakeLists.txt` - ビルド設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-mtはWindowsマニフェストファイルのマージを行うツール | E-01 (9-11行目コメント) | ○ |
| C-02 | Microsoft mt.exeのプラットフォーム非依存な代替実装 | E-01 (10-11行目コメント) | ○ |
| C-03 | -manifestオプションでマニフェストファイルを指定 | E-02 (4行目) | ○ |
| C-04 | -out:オプションで出力ファイルを指定 | E-02 (14行目) | ○ |
| C-05 | -notify_updateオプションで変更検出が可能 | E-02 (26行目), E-01 (143-162行目) | ○ |
| C-06 | 入力ファイルが未指定の場合エラー終了 | E-01 (115-117行目) | ○ |
| C-07 | 複数入力で-out未指定の場合エラー終了 | E-01 (124-126行目) | ○ |
| C-08 | 単一入力で-out未指定の場合は入力ファイルを上書き | E-01 (122-123行目) | ○ |
| C-09 | WindowsManifestMergerを使用してマージ処理 | E-01 (128, 135行目) | ○ |
| C-10 | マージ結果が空の場合はエラー終了 | E-01 (139-140行目) | ○ |
| C-11 | -notify_update時の終了コードはUnixで0xbb | E-01 (157行目) | ○ |
| C-12 | -notify_update時の終了コードはWindowsで0x41020001 | E-01 (159行目) | ○ |
| C-13 | FileOutputBufferを使用してファイル出力 | E-01 (164-171行目) | ○ |
| C-14 | サポートされていないオプションは警告を出力して無視 | E-01 (101-106行目), E-02 (Group<unsupported>) | ○ |
| C-15 | -nologoオプションは互換性のため存在するが効果なし | E-02 (13行目コメント) | ○ |
| C-16 | -help/-?/-hオプションでヘルプ表示 | E-02 (28-30行目), E-01 (108-111行目) | ○ |
| C-17 | エントリーポイントはllvm_mt_main関数 | E-01 (82行目) | ○ |
| C-18 | CvtResOptTableクラスで引数解析 | E-01 (58-63行目, 83-86行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対応する根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [x] 主要機能（マニフェストマージ）の説明が正確か
- [x] コマンドラインオプションの説明が実装と一致しているか
- [x] エラー処理の説明が実装と一致しているか
- [x] 終了コードの説明が実装と一致しているか
