---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-llvm-readtapi

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-readtapi/llvm-readtapi.cpp` - メインソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトでTBD v5形式を使用 | E-01 (85行目: WriteFT = FileType::TBD_V5) | ○ |
| C-02 | NON_TAPI_EXIT_CODEは2 | E-01 (93行目: const int NON_TAPI_EXIT_CODE = 2) | ○ |
| C-03 | identify_magicでファイルフォーマット判定 | E-01 (141行目: switch (identify_magic(...))) | ○ |
| C-04 | dylibはDylibReader::getで読み込み | E-01 (145行目: DylibReader::get) | ○ |
| C-05 | TAPIファイルはTextAPIReader::getで読み込み | E-01 (148行目: TextAPIReader::get) | ○ |
| C-06 | compareは2つの入力ファイルが必要 | E-01 (160-161行目: Ctx.Inputs.size() != 2) | ○ |
| C-07 | DiffEngineで比較を実行 | E-01 (193行目: DiffEngine(...).compareFiles) | ○ |
| C-08 | writeはTextAPIWriter::writeToStreamで出力 | E-01 (204行目: TextAPIWriter::writeToStream) | ○ |
| C-09 | mergeは2つ以上の入力ファイルが必要 | E-01 (209-210行目: Ctx.Inputs.size() < 2) | ○ |
| C-10 | InterfaceFile::mergeでマージ処理 | E-01 (220行目: Out->merge) | ○ |
| C-11 | extract/removeはarchが必要 | E-01 (473-474行目: Ctx.Arch == AK_unknown) | ○ |
| C-12 | 単一アクションのみ許可 | E-01 (557-564行目: ActionArgs.size() > 1でエラー) | ○ |
| C-13 | StubOptionsにdelete-input, delete-private-libraries, trace | E-01 (484-488行目: setStubOptions) | ○ |
| C-14 | TBD v3未満はサポートしない | E-01 (530-531行目: WriteFT < FileType::TBD_V3) | ○ |
| C-15 | ディレクトリ入力時はstubifyDirectoryで再帰処理 | E-01 (450-454行目: IsDirectory時stubifyDirectory) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対応する根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [x] 各アクションの説明が正確か
- [x] 入力ファイル数の制約が正確か
- [x] 処理フローの説明が実装と一致しているか
