---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-llvm-gsymutil

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-gsymutil/llvm-gsymutil.cpp` - メインソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --convert時は他の入力ファイル指定不可 | E-01 (615-618行目: InputFilenames.empty()チェック) | ○ |
| C-02 | --addresses-from-stdin時は入力ファイル/--address不可 | E-01 (655-659行目: チェック処理) | ○ |
| C-03 | デフォルト出力ファイル名は入力ファイル名.gsym | E-01 (506-509行目: OutFile設定) | ○ |
| C-04 | --merged-functions-filterは--merged-functionsが必要 | E-01 (208-213行目: UseMergedFunctionsチェック) | ○ |
| C-05 | スレッド数デフォルトはhardware_concurrency | E-01 (348-349行目: ThreadCount設定) | ○ |
| C-06 | ELFベースアドレスは最初のPT_LOADのp_vaddr | E-01 (288-291行目: getImageBaseAddress ELF版) | ○ |
| C-07 | Mach-Oベースアドレスは__TEXTセグメントのvmaddr | E-01 (302-318行目: getImageBaseAddress Mach-O版) | ○ |
| C-08 | GsymCreator生成と使用 | E-01 (351行目: GsymCreator Gsym(Quiet)) | ○ |
| C-09 | DWARFContext::createでDWARF解析 | E-01 (375-382行目: DWARFContext::create) | ○ |
| C-10 | DwarfTransformer.convertでDWARF変換 | E-01 (396行目: DT.convert) | ○ |
| C-11 | ObjectFileTransformer.convertでシンボル変換 | E-01 (407行目: ObjectFileTransformer::convert) | ○ |
| C-12 | Gsym.finalizeでファイナライズ | E-01 (418行目: Gsym.finalize) | ○ |
| C-13 | Gsym.saveで保存 | E-01 (429行目: Gsym.save) | ○ |
| C-14 | --verify時はDT.verifyで検証 | E-01 (434-436行目: Verify時DT.verify呼び出し) | ○ |
| C-15 | --merged-functions時はlookupAllで検索 | E-01 (531-532行目: UseMergedFunctions時lookupAll) | ○ |
| C-16 | JSONサマリー出力 | E-01 (628-649行目: JsonSummaryFile処理) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対応する根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [x] 動作モードの説明が正確か
- [x] 変換処理フローの説明が実装と一致しているか
- [x] ベースアドレス計算の説明が正確か
