---
generated_at: 2026-02-01 23:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-LLD.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `lld/tools/lld/lld.cpp` - メインエントリーポイント（116行）
- E-02: `機能一覧.csv` - 機能定義
- E-03: lld.cppのコメント（9-25行目）- 機能説明とフレーバー説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLDはLLVMプロジェクトのリンカ | E-02, E-03 | ○ |
| C-02 | ELF/COFF/Mach-O/WebAssemblyをサポート | E-03 (13-21行目), E-01 (69-73行目) | ○ |
| C-03 | lld_main関数がエントリーポイント | E-01 (75-115行目) | ○ |
| C-04 | ld.lldはELFリンカ | E-03 (18行目), E-01 (70行目) | ○ |
| C-05 | ld64はMach-Oリンカ | E-03 (19行目), E-01 (72行目) | ○ |
| C-06 | lld-linkはCOFFリンカ | E-03 (20行目), E-01 (69行目) | ○ |
| C-07 | wasm-ldはWebAssemblyリンカ | E-03 (21行目), E-01 (73行目) | ○ |
| C-08 | -flavorオプションでフレーバー指定可能 | E-03 (23-24行目) | ○ |
| C-09 | unsafeLldMainで非テスト実行 | E-01 (54-56行目, 89-92行目) | ○ |
| C-10 | LLD_ALL_DRIVERSで全ドライバ使用 | E-01 (90行目) | ○ |
| C-11 | CrashRecoveryContext有効化 | E-01 (96行目) | ○ |
| C-12 | LLD_IN_TEST環境変数でテストモード | E-01 (63-67行目) | ○ |
| C-13 | inTestVerbosityでテスト回数取得 | E-01 (63-67行目) | ○ |
| C-14 | lldMainでテスト用ループ実行 | E-01 (98-113行目) | ○ |
| C-15 | canRunAgainで再実行可能性チェック | E-01 (104-105行目) | ○ |
| C-16 | exitLldで早期終了 | E-01 (105行目) | ○ |
| C-17 | ANSIエスケープコード有効化 | E-01 (76行目) | ○ |
| C-18 | FORCE_LLD_DIAGNOSTICS_CRASH環境変数 | E-01 (78-82行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: すべての主張が根拠に基づいており、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] lld.cpp の行番号参照が最新のコードと一致するか確認
- [ ] 各フレーバー（ELF/COFF/Mach-O/WASM）の動作が正確か確認
- [ ] テストモードとプロダクションモードの分岐が正確か確認
