---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-clang-format

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/clang-format/ClangFormat.cpp` - メインソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -iは標準入力と併用不可 | E-01 (406-408行目: IsSTDINとInplaceチェック) | ○ |
| C-02 | -offset/-length/-linesは単一ファイルのみ | E-01 (709-714行目: FileNames.size() > 1チェック) | ○ |
| C-03 | 空ファイルは処理スキップ | E-01 (421-422行目: getBufferSize() == 0) | ○ |
| C-04 | fillRangesで範囲計算 | E-01 (438行目: fillRanges呼び出し) | ○ |
| C-05 | getStyleでスタイル取得 | E-01 (446-448行目: getStyle呼び出し) | ○ |
| C-06 | sortIncludesでインクルードソート | E-01 (481-482行目: sortIncludes呼び出し) | ○ |
| C-07 | reformatでフォーマット | E-01 (503-504行目: reformat呼び出し) | ○ |
| C-08 | -dump-config時はdumpConfig呼び出し | E-01 (689-690行目: DumpConfig時) | ○ |
| C-09 | -filesからファイルリスト読み込み | E-01 (692-701行目: Files処理) | ○ |
| C-10 | ファイル未指定時は標準入力 | E-01 (703-706行目: FileNames.empty()時) | ○ |
| C-11 | isIgnoredで除外チェック | E-01 (719行目: isIgnored呼び出し) | ○ |
| C-12 | .clang-format-ignoreでパターン指定 | E-01 (610-612行目: ".clang-format-ignore"検索) | ○ |
| C-13 | -i時はoverwriteChangedFiles | E-01 (526-528行目: Inplace時) | ○ |
| C-14 | -output-replacements-xml時はXML出力 | E-01 (510-511行目: OutputXML時) | ○ |
| C-15 | カーソル位置出力 | E-01 (530-538行目: Cursor.getNumOccurrences()) | ○ |
| C-16 | BOMエラーチェック | E-01 (426-435行目: InvalidBOMチェック) | ○ |
| C-17 | --fail-on-incomplete-format対応 | E-01 (542行目: ErrorOnIncompleteFormat && !Status.FormatComplete) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対応する根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [x] 入出力の説明が正確か
- [x] 処理フローの説明が実装と一致しているか
- [x] ビジネスルールの説明が正確か
