---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-ClangStaticAnalyzer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **並列実行の推奨**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/tools/scan-build/bin/scan-build` (Perlスクリプト)
- E-02: `clang/tools/scan-build/libexec/ccc-analyzer` (Perlスクリプト)
- E-03: `clang/tools/scan-build/share/scan-build/sorttable.js` (JavaScript)
- E-04: `clang/tools/scan-build/share/scan-build/scanview.css` (CSS)
- E-05: `clang/lib/StaticAnalyzer/Frontend/AnalysisConsumer.cpp` (C++ソース)
- E-06: 機能一覧.csv 行72

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | scan-buildはPerlスクリプトとして実装されている | E-01 (1行目: #!/usr/bin/env perl) | ○ |
| C-02 | Optionsハッシュで設定を管理 | E-01 (46-76行目) | ○ |
| C-03 | CCC_ANALYZER_HTML環境変数で出力先を設定 | E-01 (266行目) | ○ |
| C-04 | デフォルトで/tmp配下に出力ディレクトリを作成 | E-01 (156行目) | ○ |
| C-05 | HTMLレポートを生成する | E-01 (66行目: OutputFormat => "html") | ○ |
| C-06 | --status-bugsオプションでバグ発見時に非ゼロ終了 | E-01 (54行目: ExitStatusFoundBugs) | ○ |
| C-07 | チェッカーの有効/無効を制御可能 | E-01 (57-59行目: EnableCheckers, DisableCheckers) | ○ |
| C-08 | --report-failuresでクラッシュ情報を保存 | E-01 (68行目: ReportFailures) | ○ |
| C-09 | MaxLoopでループ展開回数を制限 | E-01 (70行目: MaxLoop) | ○ |
| C-10 | プラグインのロードが可能 | E-01 (71行目: PluginsToLoad) | ○ |
| C-11 | ccc-analyzerがコンパイラをラップ | E-02 | ○ |
| C-12 | sorttable.jsでテーブルソート機能を提供 | E-03 | ○ |
| C-13 | scanview.cssでスタイルを定義 | E-04 | ○ |
| C-14 | AnalysisConsumerが解析を統括 | E-05 | ○ |
| C-15 | シンボリック実行でパス探索を行う | E-05 (ExprEngine参照) | ○ |
| C-16 | 機能一覧での説明と一致 | E-06 | ○ |
| C-17 | 大規模プロジェクトでは並列実行を推奨 | **根拠なし** | △ |
| C-18 | パス爆発を制御するMaxLoop設定 | E-01 (70行目)、具体的な推奨値なし | △ |

## 4) 不足情報（Unknown / Missing）
- 並列実行に関する公式ドキュメントまたは実装詳細
  - 候補：scan-buildのマニュアルページ / Clang Static Analyzer公式ドキュメント
- パフォーマンスベンチマークデータ
  - 候補：LLVM/Clangのテストスイート結果 / 実測データ

## 5) リスクフラグ（レビュー観点）
- 0: 機能の基本動作に関する記述（実装から確認可能）
- 1: パフォーマンス関連の推奨事項（実測値の確認推奨）
- 0: エラー処理に関する記述（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] scan-buildスクリプトの主要オプションが網羅されているか確認
- [ ] 並列実行に関する記述の妥当性を確認
- [ ] チェッカー一覧が最新バージョンと整合しているか確認
- [ ] HTMLレポートの出力形式が実際の出力と一致するか確認
