---
generated_at: 2026-02-01 22:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：73-clangd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **補完応答時間100ms目標**：パフォーマンス要件の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/ClangdServer.cpp` (C++ソース、1194行)
- E-02: `clang-tools-extra/clangd/ClangdServer.h` (C++ヘッダ)
- E-03: `clang-tools-extra/clangd/Protocol.h` (C++ヘッダ)
- E-04: `clang-tools-extra/clangd/TUScheduler.h` (C++ヘッダ)
- E-05: `clang-tools-extra/clangd/CodeComplete.cpp` (C++ソース)
- E-06: `clang-tools-extra/clangd/XRefs.cpp` (C++ソース)
- E-07: `clang-tools-extra/clangd/Hover.cpp` (C++ソース)
- E-08: 機能一覧.csv 行74

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClangdServerのコンストラクタでインデックス・スケジューラを初期化 | E-01 (214-281行目) | ○ |
| C-02 | addDocument関数でドキュメントを登録 | E-01 (297-320行目) | ○ |
| C-03 | codeComplete関数でコード補完を処理 | E-01 (421-494行目) | ○ |
| C-04 | locateSymbolAt関数で定義ジャンプを処理 | E-01 (802-812行目) | ○ |
| C-05 | findHover関数でホバー情報を取得 | E-01 (846-858行目) | ○ |
| C-06 | TUSchedulerで非同期処理をスケジュール | E-01 (237-241行目: WorkScheduler) | ○ |
| C-07 | FileIndexで動的インデックスを管理 | E-01 (218-220行目: DynamicIdx) | ○ |
| C-08 | BackgroundIndexでバックグラウンドインデックスを管理 | E-01 (253-267行目) | ○ |
| C-09 | runWithASTで完全なASTを使用して処理 | E-01 (各関数でrunWithAST呼び出し) | ○ |
| C-10 | runWithPreambleでプリアンブルのみで高速処理 | E-01 (488-493行目) | ○ |
| C-11 | DraftStoreでオープンファイルを管理 | E-01 (176-191行目: DraftStoreFS) | ○ |
| C-12 | createConfiguredContextProviderで設定を管理 | E-01 (339-414行目) | ○ |
| C-13 | formatFile関数でコードフォーマット | E-01 (525-564行目) | ○ |
| C-14 | rename関数でリネーム処理 | E-01 (615-646行目) | ○ |
| C-15 | codeAction関数でコードアクション | E-01 (693-753行目) | ○ |
| C-16 | typeHierarchy関数で型階層取得 | E-01 (860-872行目) | ○ |
| C-17 | semanticHighlights関数でセマンティックハイライト | E-01 (1063-1078行目) | ○ |
| C-18 | UpdateIndexCallbacksでインデックス更新 | E-01 (69-174行目) | ○ |
| C-19 | optsForTest関数でテスト用オプション | E-01 (195-201行目) | ○ |
| C-20 | blockUntilIdleForTest関数でテスト同期 | E-01 (1139-1183行目) | ○ |
| C-21 | profile関数でメモリプロファイル | E-01 (1185-1191行目) | ○ |
| C-22 | 補完応答時間100ms目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の公式ドキュメントまたは設計文書
  - 候補：clangdの公式ドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: LSP機能の実装に関する記述（コードから確認済み）
- 0: 非同期処理の仕組みに関する記述（コードから確認済み）
- 1: パフォーマンス要件の具体的な数値（検証推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] ClangdServer.cppの主要関数（codeComplete、locateSymbolAt等）の動作確認
- [ ] TUSchedulerの非同期処理パターンが正確か確認
- [ ] バックグラウンドインデックスの永続化形式を確認
- [ ] LSPプロトコルの対応状況が最新か確認
