---
generated_at: 2026-02-01 22:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-clang-check

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/tools/clang-check/ClangCheck.cpp` (C++ソース、260行)
- E-02: 機能一覧.csv 行75

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドラインオプション定義 | E-01 (59-98行目) | ○ |
| C-02 | FixItOptionsクラスでFixIt設定を管理 | E-01 (103-117行目) | ○ |
| C-03 | FixItRewriterでIncludeInDiagnosticCountsをfalse | E-01 (133行目) | ○ |
| C-04 | ClangCheckFixItActionでFixIt適用 | E-01 (138-146行目) | ○ |
| C-05 | DumpSyntaxTreeでSyntax Treeをダンプ | E-01 (148-172行目) | ○ |
| C-06 | ClangCheckActionFactoryでAST操作を選択 | E-01 (174-190行目) | ○ |
| C-07 | --ast-listでCreateASTDeclNodeLister | E-01 (177-178行目) | ○ |
| C-08 | --ast-dumpでCreateASTDumper | E-01 (179-185行目) | ○ |
| C-09 | --ast-printでCreateASTPrinter | E-01 (186-187行目) | ○ |
| C-10 | main関数でモード選択 | E-01 (194-259行目) | ○ |
| C-11 | --analyzeでAnalysisAction | E-01 (249-250行目) | ○ |
| C-12 | ArgumentsAdjusterで--analyze用に引数調整 | E-01 (233-243行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ClangCheck.cppの各モードの動作確認
- [ ] --fixit の動作がソースファイルを正しく更新するか確認
