---
generated_at: 2026-02-01 22:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-clang-refactor

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/tools/clang-refactor/ClangRefactor.cpp` (C++ソース、646行)
- E-02: `clang/tools/clang-refactor/TestSupport.cpp` (C++ソース)
- E-03: 機能一覧.csv 行76

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceSelectionArgumentで選択範囲を解析 | E-01 (54-166行目) | ○ |
| C-02 | TestSourceSelectionArgumentでテスト用選択範囲 | E-01 (89-110行目) | ○ |
| C-03 | SourceRangeSelectionArgumentで通常の選択範囲 | E-01 (113-145行目) | ○ |
| C-04 | fromString関数で選択文字列をパース | E-01 (147-166行目) | ○ |
| C-05 | RefactoringActionCommandLineOptionsでオプション管理 | E-01 (170-187行目) | ○ |
| C-06 | CommandLineRefactoringOptionVisitorでオプション値取得 | E-01 (191-217行目) | ○ |
| C-07 | CommandLineRefactoringOptionCreatorでオプション作成 | E-01 (221-253行目) | ○ |
| C-08 | RefactoringActionSubcommandでサブコマンド管理 | E-01 (256-315行目) | ○ |
| C-09 | ClangRefactorConsumerで変更を収集 | E-01 (317-344行目) | ○ |
| C-10 | ClangRefactorToolで全体を統括 | E-01 (346-607行目) | ○ |
| C-11 | Init関数でサブコマンドとルールを初期化 | E-01 (375-387行目) | ○ |
| C-12 | callback関数でAST処理を実行 | E-01 (394-429行目) | ○ |
| C-13 | applySourceChanges関数で変更を適用 | E-01 (481-517行目) | ○ |
| C-14 | main関数で全体のフロー制御 | E-01 (611-645行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ClangRefactor.cppの主要クラスの役割確認
- [ ] サブコマンドの種類と各アクションの確認
- [ ] -selection オプションの形式が正確か確認
