---
generated_at: 2026-02-01 22:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-include-cleaner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/include-cleaner/tool/IncludeCleaner.cpp` (C++ソース、415行)
- E-02: `clang-tools-extra/include-cleaner/include/clang-include-cleaner/Analysis.h` (C++ヘッダ)
- E-03: 機能一覧.csv 行79

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドラインオプション定義（edit, print等） | E-01 (53-117行目) | ○ |
| C-02 | PrintStyle enumでchanges/finalを定義 | E-01 (76-86行目) | ○ |
| C-03 | Actionクラスでフロントエンドアクション実装 | E-01 (131-252行目) | ○ |
| C-04 | BeginInvocation関数で診断設定を調整 | E-01 (144-151行目) | ○ |
| C-05 | ExecuteAction関数でPP記録を設定 | E-01 (153-168行目) | ○ |
| C-06 | CreateASTConsumer関数でRecordedAST記録 | E-01 (170-173行目) | ○ |
| C-07 | EndSourceFile関数で解析と結果出力 | E-01 (175-237行目) | ○ |
| C-08 | analyze関数で不要/不足インクルード検出 | E-01 (195-197行目) | ○ |
| C-09 | fixIncludes関数で修正を生成 | E-01 (219行目) | ○ |
| C-10 | ActionFactoryクラスでAction生成 | E-01 (253-270行目) | ○ |
| C-11 | matchesAny関数で正規表現フィルタ構築 | E-01 (274-296行目) | ○ |
| C-12 | headerFilter関数でフィルタ統合 | E-01 (298-311行目) | ○ |
| C-13 | mapInputsToAbsPaths関数でパス変換 | E-01 (315-352行目) | ○ |
| C-14 | main関数で全体フロー制御 | E-01 (358-414行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] IncludeCleaner.cppの処理フロー確認
- [ ] analyze関数の検出アルゴリズム確認
- [ ] --edit オプションの動作確認
