---
generated_at: 2026-02-01 22:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-clang-include-fixer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clang-include-fixer/tool/ClangIncludeFixer.cpp` (C++ソース、478行)
- E-02: 機能一覧.csv 行80

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DatabaseFormatTy enumでfixed/yaml/fuzzyYamlを定義 | E-01 (84-88行目) | ○ |
| C-02 | コマンドラインオプション定義（--db, --input等） | E-01 (90-158行目) | ○ |
| C-03 | createSymbolIndexManager関数でDB形式別にインデックス作成 | E-01 (160-234行目) | ○ |
| C-04 | fixed形式ではInMemorySymbolIndexを使用 | E-01 (166-188行目) | ○ |
| C-05 | yaml形式ではYamlSymbolIndexを使用 | E-01 (190-215行目) | ○ |
| C-06 | fuzzyYaml形式ではFuzzySymbolIndexを使用 | E-01 (217-231行目) | ○ |
| C-07 | writeToJson関数でJSON形式出力 | E-01 (236-261行目) | ○ |
| C-08 | includeFixerMain関数でメイン処理 | E-01 (263-471行目) | ○ |
| C-09 | STDINMode処理でstdinからソース読み込み | E-01 (279-293行目) | ○ |
| C-10 | --insert-header処理でYAML入力からヘッダー挿入 | E-01 (295-353行目) | ○ |
| C-11 | --query-symbol処理でシンボル直接クエリ | E-01 (361-381行目) | ○ |
| C-12 | IncludeFixerActionFactoryでClangTool実行 | E-01 (384-397行目) | ○ |
| C-13 | --output-headers処理でJSON出力 | E-01 (401-405行目) | ○ |
| C-14 | createIncludeFixerReplacementsで修正生成 | E-01 (423-424行目) | ○ |
| C-15 | Rewriter::overwriteChangedFilesでファイル更新 | E-01 (463-470行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ClangIncludeFixer.cppの処理フロー確認
- [ ] 各DB形式（fixed/yaml/fuzzyYaml）の動作確認
- [ ] --stdinモードでのエディタ統合動作確認
