---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-clang-move

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な性能指標の根拠なし
  2. **テンプレート対応**：コード確認はあるが明示的なドキュメントなし
  3. **エラーコード体系**：コードから推測した部分あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clang-move/tool/ClangMove.cpp` - mainエントリーポイント
- E-02: `clang-tools-extra/clang-move/Move.h` - データ構造定義
- E-03: `clang-tools-extra/clang-move/Move.cpp` - コア処理実装
- E-04: `clang-tools-extra/clang-move/HelperDeclRefGraph.h` - 依存関係グラフ定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-moveはコードを別ファイルに移動するツール | E-05 | ○ |
| C-02 | 移動対象シンボルはnamesオプションで指定 | E-01 (42-45行目) | ○ |
| C-03 | old_header/old_cc/new_header/new_ccオプションでファイルパス指定 | E-01 (47-63行目) | ○ |
| C-04 | old_depend_on_newとnew_depend_on_oldは同時指定不可 | E-01 (107-112行目) | ○ |
| C-05 | MoveDefinitionSpecで移動仕様を管理 | E-02 (58-77行目) | ○ |
| C-06 | ClangMoveContextで実行時コンテキストを管理 | E-02 (79-94行目) | ○ |
| C-07 | HelperDeclRefGraphで依存関係を解析 | E-04 (19-76行目) | ○ |
| C-08 | registerMatchersでASTマッチャーを登録 | E-03 (500-661行目) | ○ |
| C-09 | moveDeclsToNewFilesで新ファイルへ宣言を挿入 | E-03 (800-842行目) | ○ |
| C-10 | removeDeclsInOldFilesで旧ファイルから宣言を削除 | E-03 (722-798行目) | ○ |
| C-11 | dump_declsで宣言一覧をJSON出力 | E-01 (143-159行目) | ○ |
| C-12 | dump_resultで変換結果をJSON出力 | E-01 (192-216行目) | ○ |
| C-13 | styleオプションでフォーマットスタイル指定（デフォルトllvm） | E-01 (79-82行目) | ○ |
| C-14 | -fparse-all-commentsオプションが自動追加される | E-01 (117-118行目) | ○ |
| C-15 | 全宣言移動時はファイル全体を移動 | E-03 (924-930行目) | ○ |
| C-16 | 未使用ヘルパーは削除される | E-03 (733-746行目) | ○ |
| C-17 | テンプレートクラス・関数の移動をサポート | E-03 (265-271行目) | ○ |
| C-18 | 大規模プロジェクトでも実用的な時間内に完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値指標
  - 候補：ベンチマークテスト結果 / 性能テストドキュメント / ユーザーガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の説明は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス関連の主張は実測値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-18のパフォーマンス要件について、実際の使用ケースで妥当か確認
- [ ] テンプレート対応の範囲（部分特殊化、変数テンプレート等）を確認
- [ ] エラーコード体系が実装と一致しているか確認
