---
generated_at: 2026-02-01 22:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：82-clang-reorder-fields

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な性能指標の根拠なし
  2. **アクセス指定子制約**：コード確認はあるが明示的なドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clang-reorder-fields/tool/ClangReorderFields.cpp` - mainエントリーポイント
- E-02: `clang-tools-extra/clang-reorder-fields/ReorderFieldsAction.h` - 公開API定義
- E-03: `clang-tools-extra/clang-reorder-fields/ReorderFieldsAction.cpp` - コア処理実装
- E-04: `clang-tools-extra/clang-reorder-fields/Designator.h` - 指示付き初期化子対応
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-reorder-fieldsは構造体/クラスのフィールド順序を変更する | E-05 | ○ |
| C-02 | record-nameオプションで対象の構造体/クラス名を指定 | E-01 (28-31行目) | ○ |
| C-03 | fields-orderオプションで希望するフィールド順序を指定 | E-01 (33-36行目) | ○ |
| C-04 | findDefinitionでrecord-nameに一致する定義を検索 | E-03 (40-55行目) | ○ |
| C-05 | declaresMultipleFieldsInStatementで複数フィールド宣言を検出 | E-03 (57-68行目) | ○ |
| C-06 | declaresMultipleFieldsInMacroでマクロによる複数フィールドを検出 | E-03 (70-81行目) | ○ |
| C-07 | isSafeToRewriteで総合安全性判定を行う | E-03 (112-134行目) | ○ |
| C-08 | getNewFieldsOrderで新しい順序のマッピングを計算 | E-03 (139-165行目) | ○ |
| C-09 | reorderFieldsInDefinitionでフィールド宣言を並べ替え | E-03 (380-410行目) | ○ |
| C-10 | reorderFieldsInConstructorでコンストラクタ初期化リストを並べ替え | E-03 (417-470行目) | ○ |
| C-11 | reorderFieldsInInitListExprで初期化リスト式を並べ替え | E-03 (524-655行目) | ○ |
| C-12 | flexible array memberは末尾に残らなければならない | E-03 (167-180行目 isOrderValid) | ○ |
| C-13 | 初期化式で他のフィールドを参照する場合は警告を出力 | E-03 (435-455行目 findMembersUsedInInitExpr) | ○ |
| C-14 | C++20の指示付き初期化子をサポート | E-04 (全体) | ○ |
| C-15 | プリプロセッサディレクティブを含むフィールド定義は処理不可 | E-03 (83-110行目 containsPreprocessorDirectives) | ○ |
| C-16 | 通常のソースファイルサイズでは即座に完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値指標
  - 候補：ベンチマークテスト結果 / 性能テストドキュメント / ユーザーガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の説明は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス関連の主張は実測値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-16のパフォーマンス要件について、実際の使用ケースで妥当か確認
- [ ] アクセス指定子をまたぐフィールド並べ替えの制約を確認
- [ ] マクロ展開時の安全性チェックが十分か確認
