---
generated_at: 2026-02-01 22:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：83-clang-query

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な性能指標の根拠なし
  2. **補完機能の詳細動作**：コード確認済みだが詳細仕様なし

## 2) 参照した情報（Evidence一覧）

- E-01: `clang-tools-extra/clang-query/tool/ClangQuery.cpp` - mainエントリーポイント
- E-02: `clang-tools-extra/clang-query/Query.h` - Queryクラス定義
- E-03: `clang-tools-extra/clang-query/Query.cpp` - Query実装
- E-04: `clang-tools-extra/clang-query/QueryParser.h` - パーサーAPI
- E-05: `clang-tools-extra/clang-query/QueryParser.cpp` - パーサー実装
- E-06: `clang-tools-extra/clang-query/QuerySession.h` - セッション状態
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-queryはASTに対してインタラクティブにクエリを実行する | E-01 (9-25行目コメント) | ○ |
| C-02 | -cオプションでコマンドを指定して実行 | E-01 (61-63行目) | ○ |
| C-03 | -fオプションでファイルからコマンドを読み込む | E-01 (65-68行目) | ○ |
| C-04 | --preloadでプリロード後インタラクティブモードに入る | E-01 (70-73行目) | ○ |
| C-05 | -cと-fは同時に指定不可 | E-01 (93-96行目) | ○ |
| C-06 | -c/-fと--preloadは同時に指定不可 | E-01 (98-102行目) | ○ |
| C-07 | ClangTool.buildASTsでAST構築 | E-01 (121行目) | ○ |
| C-08 | QuerySessionがAST参照と設定を管理 | E-06 (26-44行目) | ○ |
| C-09 | QueryParser::parseでクエリをパース | E-05 (362-364行目) | ○ |
| C-10 | MatchQuery::runでマッチを実行 | E-03 (109-203行目) | ○ |
| C-11 | 3つの出力モード(diag/print/detailed-ast) | E-02 (20行目), E-03 (171-193行目) | ○ |
| C-12 | デフォルトでルートマッチャーを"root"にバインド | E-03 (127-131行目), E-06 (37行目) | ○ |
| C-13 | let コマンドで名前付きマッチャーを定義 | E-03 (205-212行目), E-05 (242-261行目) | ○ |
| C-14 | traversal kindでAST走査方法を変更可能 | E-06 (42行目), E-05 (130-141行目) | ○ |
| C-15 | LineEditorで入力補完機能を提供 | E-01 (154-157行目), E-05 (366-373行目) | ○ |
| C-16 | quitコマンドでセッション終了 | E-03 (78-81行目) | ○ |
| C-17 | FileQueryでファイルからコマンドを順次実行 | E-03 (219-238行目) | ○ |
| C-18 | AST構築はソースファイルサイズに依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値指標
  - 候補：ベンチマークテスト結果 / 性能テストドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の説明は全てソースコードで確認済み
- 1: 低リスク - パフォーマンス関連は一般論として妥当

## 6) レビュアーチェックリスト（最小）
- [ ] C-18のパフォーマンス要件について、実際の使用ケースで妥当か確認
- [ ] 補完機能の対応範囲（コマンド名、マッチャー名、変数名等）を確認
- [ ] エラーメッセージの日本語化対応が必要か確認
