---
generated_at: 2026-02-01 22:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-pp-trace

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし - 全ての主張がソースコードで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `clang-tools-extra/pp-trace/PPTrace.cpp` - mainエントリーポイント
- E-02: `clang-tools-extra/pp-trace/PPCallbacksTracker.h` - トラッカークラス定義
- E-03: `clang-tools-extra/pp-trace/PPCallbacksTracker.cpp` - コールバック実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pp-traceはプリプロセッサのコールバック活動をトレースする | E-01 (9-14行目コメント) | ○ |
| C-02 | 出力はYAML形式 | E-01 (94-100行目) | ○ |
| C-03 | -callbacksオプションでGlobパターンを指定 | E-01 (59-65行目) | ○ |
| C-04 | -outputオプションで出力先を指定（デフォルト: "-"） | E-01 (67-70行目) | ○ |
| C-05 | "-"プレフィックスでコールバックを除外 | E-01 (140-145行目) | ○ |
| C-06 | PPCallbacksTrackerがPPCallbacksを継承 | E-02 (74行目) | ○ |
| C-07 | FileChanged等のコールバックをオーバーライド | E-02 (89-147行目) | ○ |
| C-08 | CallbackCallがコールバック名と引数を保持 | E-02 (44-53行目) | ○ |
| C-09 | Argumentが名前と値のペアを保持 | E-02 (39-42行目) | ○ |
| C-10 | PPTraceActionがCreateASTConsumerでトラッカーを登録 | E-01 (85-91行目) | ○ |
| C-11 | EndSourceFileActionでYAML出力を行う | E-01 (93-103行目) | ○ |
| C-12 | beginCallbackでトレース開始 | E-02 (152行目) | ○ |
| C-13 | appendArgumentで引数を追加 | E-02 (158-216行目) | ○ |
| C-14 | フィルタがCallbackIsEnabledで管理される | E-02 (230行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] YAML出力形式が期待通りか確認（サンプル出力との比較）
- [ ] 対応するコールバック一覧が網羅されているか確認
- [ ] フィルタのGlobパターン構文がドキュメント化されているか確認
