---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-clang-scan-deps

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし - 全ての主張がソースコードで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/clang-scan-deps/ClangScanDeps.cpp` - mainエントリーポイント、主要ロジック
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-scan-depsはモジュール依存関係をスキャンする | E-01 (9-17行目コメント、ファイル名) | ○ |
| C-02 | 出力形式はmake/p1689/experimental-full | E-01 (146-160行目) | ○ |
| C-03 | スキャンモードはpreprocess-dependency-directives/preprocess | E-01 (130-144行目) | ○ |
| C-04 | -jオプションで並列スレッド数を指定 | E-01 (197-204行目) | ○ |
| C-05 | -oオプションで出力ファイルを指定 | E-01 (192-193行目) | ○ |
| C-06 | --compilation-databaseでコンパイルDBを指定 | E-01 (206-207行目) | ○ |
| C-07 | --と--compilation-databaseは排他 | E-01 (760-764行目) | ○ |
| C-08 | SharedStreamでスレッドセーフな出力 | E-01 (250-262行目) | ○ |
| C-09 | ResourceDirectoryCacheでリソースディレクトリをキャッシュ | E-01 (264-324行目) | ○ |
| C-10 | FullDepsクラスで依存関係を管理 | E-01 (387-618行目) | ○ |
| C-11 | P1689Depsクラスでp1689形式出力 | E-01 (649-715行目) | ○ |
| C-12 | ThreadPoolで並列実行 | E-01 (1147-1158行目) | ○ |
| C-13 | ScanningTaskでスキャン処理 | E-01 (984-1136行目) | ○ |
| C-14 | getDependencyFileでMake形式取得 | E-01 (1008-1015行目) | ○ |
| C-15 | getP1689ModuleDependencyFileでP1689形式取得 | E-01 (1024-1030行目) | ○ |
| C-16 | getTranslationUnitDependenciesでFull形式取得 | E-01 (1115-1117行目) | ○ |
| C-17 | --verboseでVFS統計情報を出力 | E-01 (1163-1170行目) | ○ |
| C-18 | --print-timingで処理時間を出力 | E-01 (1172-1180行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 出力形式（make/p1689/full）の使い分け基準を確認
- [ ] P1689形式の出力仕様がC++標準と整合しているか確認
- [ ] 並列実行時のスレッドセーフティを確認
