---
generated_at: 2026-02-01 22:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-clang-offload-bundler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし - 全ての主張がソースコードで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/clang-offload-bundler/ClangOffloadBundler.cpp` - mainエントリーポイント
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-offload-bundlerはファイルをバンドル/アンバンドルする | E-01 (9-12行目コメント, 159-162行目) | ○ |
| C-02 | -typeでファイルタイプを指定（i/ii/cui/hipi/d/ll/bc/s/o/a/gch/ast） | E-01 (95-111行目) | ○ |
| C-03 | -unbundleでアンバンドルモード | E-01 (112-115行目) | ○ |
| C-04 | -listでバンドルID一覧表示 | E-01 (116-118行目) | ○ |
| C-05 | -targetsでターゲット指定 | E-01 (91-94行目) | ○ |
| C-06 | -allow-missing-bundlesで欠落バンドル許可 | E-01 (124-128行目) | ○ |
| C-07 | -bundle-alignでアライメント指定（デフォルト1） | E-01 (129-132行目) | ○ |
| C-08 | -compressで出力を圧縮 | E-01 (143-145行目) | ○ |
| C-09 | llvm-objcopyを検索して使用 | E-01 (220-230行目) | ○ |
| C-10 | -inputsと-inputは同時使用不可 | E-01 (232-237行目) | ○ |
| C-11 | -inputsは非推奨 | E-01 (239-240行目) | ○ |
| C-12 | -listと-unbundleは同時使用不可 | E-01 (264-269行目) | ○ |
| C-13 | -listは1入力のみ | E-01 (270-273行目) | ○ |
| C-14 | アーカイブ(-type=a)はアンバンドル専用 | E-01 (325-329行目) | ○ |
| C-15 | バンドル時は入力数=ターゲット数 | E-01 (335-339行目) | ○ |
| C-16 | ターゲット形式はoffload-kind-triple | E-01 (358-365行目) | ○ |
| C-17 | HIPのみの場合はホストターゲット不要 | E-01 (412-415行目, 392-393行目) | ○ |
| C-18 | BundleFiles/UnbundleFiles/UnbundleArchiveで処理実行 | E-01 (428-432行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] サポートするファイルタイプの動作を個別に確認
- [ ] TargetID競合チェックのルールを確認
- [ ] llvm-objcopyへの依存関係を確認
