---
generated_at: 2026-02-01 22:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-clang-sycl-linker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし - 全ての主張がソースコードで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/clang-sycl-linker/ClangSYCLLinker.cpp` - mainエントリーポイント、主要ロジック
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | clang-sycl-linkerはSYCLデバイスイメージをリンクする | E-01 (9-14行目コメント) | ○ |
| C-02 | -o オプションが必須 | E-01 (605-607行目) | ○ |
| C-03 | -triple オプションが必須 | E-01 (609-610行目) | ○ |
| C-04 | 入力はLLVMビットコード形式のみ | E-01 (197-198行目) | ○ |
| C-05 | --save-tempsで一時ファイルを保存 | E-01 (603行目, 136-139行目) | ○ |
| C-06 | --dry-runでコマンド表示のみ | E-01 (602行目, 174-175行目) | ○ |
| C-07 | --verboseで詳細出力 | E-01 (601行目, 174行目) | ○ |
| C-08 | linkDeviceCodeでビットコードをリンク | E-01 (251-313行目) | ○ |
| C-09 | getSYCLDeviceLibsでデバイスライブラリを取得 | E-01 (221-243行目) | ○ |
| C-10 | Linker::linkInModuleでリンク実行 | E-01 (264行目, 281行目) | ○ |
| C-11 | LinkOnlyNeededフラグでライブラリリンク | E-01 (280行目) | ○ |
| C-12 | runSPIRVCodeGenでSPIR-V生成 | E-01 (319-375行目) | ○ |
| C-13 | SPIR-Vバックエンドを使用 | E-01 (337-339行目) | ○ |
| C-14 | runAOTCompileIntelGPUでocloc使用 | E-01 (413-443行目, 416-417行目) | ○ |
| C-15 | runAOTCompileIntelCPUでopencl-aot使用 | E-01 (385-403行目, 388-389行目) | ○ |
| C-16 | isKernelでカーネル関数を判定 | E-01 (464-469行目) | ○ |
| C-17 | SPIR_KERNEL/AMDGPU_KERNEL/PTX_Kernelをサポート | E-01 (466-468行目) | ○ |
| C-18 | OffloadBinary::writeで出力 | E-01 (559行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み
- 1: 将来対応予定 - SPIR-V入力サポートはTODOコメントあり（195-196行目）

## 6) レビュアーチェックリスト（最小）
- [ ] AOTコンパイル対象アーキテクチャ（Intel GPU/CPU）を確認
- [ ] oclocとopencl-aotのインストール要件を確認
- [ ] SYCLデバイスライブラリのパス設定を確認
