---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-diagtool

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値基準の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/diagtool/diagtool_main.cpp`（17-25行目）
- E-02: `clang/tools/diagtool/DiagTool.h`（24-69行目）
- E-03: `clang/tools/diagtool/DiagTool.cpp`（20-66行目）
- E-04: `clang/tools/diagtool/DiagnosticNames.h`（18-117行目）
- E-05: `clang/tools/diagtool/DiagnosticNames.cpp`（17-103行目）
- E-06: `clang/tools/diagtool/ListWarnings.cpp`（21-102行目）
- E-07: `clang/tools/diagtool/TreeView.cpp`（18-179行目）
- E-08: `clang/tools/diagtool/ShowEnabledWarnings.cpp`（20-149行目）
- E-09: `clang/tools/diagtool/FindDiagnosticID.cpp`（15-74行目）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`（92行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | diagtoolはClang診断情報調査ツールである | E-10 | ○ |
| C-02 | サブコマンドにlist-warnings/tree/show-enabled/find-diagnostic-idがある | E-06, E-07, E-08, E-09 | ○ |
| C-03 | main関数でargv[1]からサブコマンドを取得する | E-01 | ○ |
| C-04 | DiagToolsクラスでツールを管理する | E-03 | ○ |
| C-05 | DEF_DIAGTOOLマクロでサブコマンドを定義する | E-02 | ○ |
| C-06 | DiagnosticRecord構造体で診断名とIDを保持 | E-04 | ○ |
| C-07 | GroupRecord構造体で警告グループの階層を表現 | E-04 | ○ |
| C-08 | ListWarningsでフラグ有無により警告を分類 | E-06（49-73行目） | ○ |
| C-09 | TreeViewで色分け表示を行う（緑/黄/赤） | E-07（63-70行目） | ○ |
| C-10 | ShowEnabledWarningsでCompilerInvocationを作成 | E-08（57-89行目） | ○ |
| C-11 | FindDiagnosticIDで診断名とIDの相互変換 | E-09（21-74行目） | ○ |
| C-12 | getBuiltinDiagnosticsByName()で診断データ取得 | E-05（23-25行目） | ○ |
| C-13 | getDiagnosticGroups()でグループ情報取得 | E-05（101-103行目） | ○ |
| C-14 | Note/Trap診断は警告リストから除外される | E-06（56-62行目） | ○ |
| C-15 | ToolMapでコマンド名からツールをマッピング | E-03（25-26行目） | ○ |
| C-16 | 不明コマンド時は使用法を表示して終了 | E-01（22-24行目） | ○ |
| C-17 | 統計情報として警告フラグ率を計算 | E-06（83-97行目） | ○ |
| C-18 | パフォーマンス要件は特に規定なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件に関する具体的なドキュメントやテストが見つからない
  - 候補：設計ドキュメント / テストコード / ベンチマーク仕様

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 機能仕様は全てソースコードから確認可能
- 0: 低リスク - データ構造の定義も明確
- 1: 中リスク - パフォーマンス要件の具体的基準なし（ただし内部ツールのため影響小）

## 6) レビュアーチェックリスト（最小）

- [ ] 各サブコマンドの動作がソースコードと一致することを確認
- [ ] DiagnosticRecord/GroupRecordのデータ構造がヘッダファイルと一致
- [ ] 色分け表示のルール（BR-91-02）がTreeView.cppと一致
- [ ] エラー処理の記述が実装と一致
