---
generated_at: 2026-02-01 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：92-libclang

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ABI安定性に関する主張**：公式ドキュメントとの照合が必要
  2. **パフォーマンス要件**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/libclang/CIndex.cpp`（1-200行目）
- E-02: `clang/tools/libclang/CIndexer.h`（1-167行目）
- E-03: `clang/tools/libclang/CIndexer.cpp`（1-226行目）
- E-04: `clang/tools/libclang/CXCursor.h`（ファイル全体）
- E-05: `clang/tools/libclang/CXType.h`（ファイル全体）
- E-06: `clang/tools/libclang/CursorVisitor.h`（ファイル全体）
- E-07: `clang/tools/libclang/CXTranslationUnit.h`（ファイル全体）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（93行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libclangはClang機能を外部プログラムから利用するためのC言語API | E-08 | ○ |
| C-02 | CIndexerクラスがインデクサの中心 | E-02, E-03 | ○ |
| C-03 | MakeCXTranslationUnit()でTU作成 | E-01（82-97行目） | ○ |
| C-04 | CXTranslationUnitImplがTUの内部表現 | E-07 | ○ |
| C-05 | CursorVisitorでAST巡回を実装 | E-06 | ○ |
| C-06 | getClangResourcesPath()でリソースパス取得 | E-03（95-143行目） | ○ |
| C-07 | LibclangInvocationReporterでログ記録 | E-03（155-225行目） | ○ |
| C-08 | PCHContainerOperationsを使用 | E-02（41行目） | ○ |
| C-09 | RunSafely()でクラッシュリカバリ | E-02（128-129行目） | ○ |
| C-10 | SetSafetyThreadStackSizeでスタック管理 | E-02（122行目） | ○ |
| C-11 | OnlyLocalDeclsオプションをサポート | E-02（35, 58-59行目） | ○ |
| C-12 | DisplayDiagnosticsオプションをサポート | E-02（36, 61-64行目） | ○ |
| C-13 | StorePreamblesInMemoryオプションをサポート | E-02（37, 82-85行目） | ○ |
| C-14 | PreambleStoragePathを設定可能 | E-02（45, 87-91行目） | ○ |
| C-15 | InvocationEmissionPathを設定可能 | E-02（46, 93-97行目） | ○ |
| C-16 | cxindex名前空間で補助関数を提供 | E-02（138-163行目） | ○ |
| C-17 | getMacroInfo()でマクロ情報取得 | E-02（143-148行目） | ○ |
| C-18 | checkForMacroInMacroDefinition()でマクロ内マクロ確認 | E-02（153-162行目） | ○ |
| C-19 | libclangはABI安定性を重視して設計されている | **根拠なし（ドキュメント参照必要）** | △ |
| C-20 | プリアンブルキャッシュによる再解析高速化 | **根拠なし（実装詳細要確認）** | △ |

## 4) 不足情報（Unknown / Missing）

- ABI安定性に関する公式ドキュメント
  - 候補：Clang公式ドキュメント / リリースノート / 設計文書
- パフォーマンス要件に関するベンチマーク
  - 候補：テストコード / ベンチマークスイート

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要API構造はソースコードから確認可能
- 1: 中リスク - ABI安定性は公式ドキュメントとの照合が必要
- 1: 中リスク - パフォーマンス関連の主張は実測による検証が必要

## 6) レビュアーチェックリスト（最小）

- [ ] CIndexer構造体のメンバがヘッダファイルと一致
- [ ] MakeCXTranslationUnit()の実装がCIndex.cppと一致
- [ ] CursorVisitorのインターフェースが正確に記述されている
- [ ] エラーコード（CXError_*）の説明が正確
- [ ] ABI安定性に関する主張を公式ドキュメントで確認
