---
generated_at: 2026-02-01 12:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：93-llvm-cfi-verify

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-cfi-verify/llvm-cfi-verify.cpp`（1-289行目）
- E-02: `llvm/tools/llvm-cfi-verify/lib/FileAnalysis.cpp`（1-605行目）
- E-03: `llvm/tools/llvm-cfi-verify/lib/GraphBuilder.cpp`（1-341行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（94行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-cfi-verifyはCFI検証ツールである | E-04 | ○ |
| C-02 | main()でターゲット初期化を行う | E-01（265-268行目） | ○ |
| C-03 | FileAnalysis::Create()でバイナリ解析 | E-02（73-116行目） | ○ |
| C-04 | x86/x86_64/AArch64をサポート | E-02（88-96行目） | ○ |
| C-05 | initialiseDisassemblyMembers()でディスアセンブラ設定 | E-02（374-432行目） | ○ |
| C-06 | parseCodeSections()でコードセクション解析 | E-02（434-478行目） | ○ |
| C-07 | parseSectionContents()で命令パース | E-02（480-542行目） | ○ |
| C-08 | validateCFIProtection()でCFI保護判定 | E-02（284-309行目） | ○ |
| C-09 | CFIProtectionStatusの各値が定義されている | E-02（55-71行目） | ○ |
| C-10 | GraphBuilder::buildFlowGraph()でグラフ構築 | E-03（95-110行目） | ○ |
| C-11 | buildFlowGraphImpl()で再帰的グラフ構築 | E-03（197-337行目） | ○ |
| C-12 | buildFlowsToUndefined()でトラップパス確認 | E-03（112-195行目） | ○ |
| C-13 | SearchLengthForConditionalBranchでグラフ探索深度制限 | E-03（51-56行目） | ○ |
| C-14 | デフォルト探索深度は20 | E-03（56行目、init(20)） | ○ |
| C-15 | SpecialCaseList::create()で無視リスト読込 | E-01（273-282行目） | ○ |
| C-16 | printIndirectCFInstructions()で検証実行 | E-01（130-254行目） | ○ |
| C-17 | getIndirectInstructions()で間接CF命令取得 | E-02（262-265行目） | ○ |
| C-18 | symbolizeInlinedCode()でシンボル化 | E-02（277-282行目） | ○ |
| C-19 | indirectCFOperandClobber()でレジスタクロバー検出 | E-02（311-367行目） | ○ |
| C-20 | isCFITrap()でトラップ命令判定 | E-02（173-176行目） | ○ |
| C-21 | willTrapOnCFIViolation()でCFI違反トラップ判定 | E-02（178-187行目） | ○ |
| C-22 | 大規模バイナリでファイルサイズに比例した時間を要する | **根拠なし（実測必要）** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンスに関するベンチマーク結果
  - 候補：テストスイート / ベンチマークドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要機能はソースコードから確認可能
- 0: 低リスク - CFIProtectionStatusの各値が明確に定義されている
- 1: 中リスク - パフォーマンス要件は実測が必要

## 6) レビュアーチェックリスト（最小）

- [ ] CFIProtectionStatusの全値（6種類）が正確に記述されている
- [ ] サポートアーキテクチャ（x86/x86_64/AArch64）が正確
- [ ] コマンドラインオプションがソースと一致
- [ ] グラフ探索深度のデフォルト値（20）が正確
- [ ] 主要関数の行番号が実際のコードと一致
