---
generated_at: 2026-02-01 12:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：94-sancov

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/sancov/sancov.cpp`（1-1417行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（95行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sancovはサニタイザカバレッジデータの処理ツールである | E-02 | ○ |
| C-02 | FileHeader構造体でビット幅とマジックを保持 | E-01（121-124行目） | ○ |
| C-03 | BinCoverageMagicは0xC0BFFFFF | E-01（126行目） | ○ |
| C-04 | Bitness32/Bitness64で32/64bit判定 | E-01（127-128行目） | ○ |
| C-05 | RawCoverage::read()で.sancov読込 | E-01（236-276行目） | ○ |
| C-06 | RawCoverage::write()で.sancov書込 | E-01（289-314行目） | ○ |
| C-07 | アドレス0は無効として除外 | E-01（273行目、Addrs->erase(0)） | ○ |
| C-08 | SancovFileRegexで.sancovファイル判定 | E-01（130行目） | ○ |
| C-09 | SymcovFileRegexで.symcovファイル判定 | E-01（131行目） | ○ |
| C-10 | createSymbolizer()でシンボライザ作成 | E-01（494-499行目） | ○ |
| C-11 | getCoveragePoints()でカバレッジポイント取得 | E-01（551-622行目） | ○ |
| C-12 | findSanitizerCovFunctions()でカバレッジ関数検索 | E-01（675-718行目） | ○ |
| C-13 | isCoveragePointSymbol()でシンボル判定 | E-01（624-632行目） | ○ |
| C-14 | getObjectCoveragePoints()でカバレッジポイントアドレス取得 | E-01（738-816行目） | ○ |
| C-15 | diffRawCoverage()で差分計算 | E-01（1086-1107行目） | ○ |
| C-16 | unionRawCoverage()で結合処理 | E-01（1109-1134行目） | ○ |
| C-17 | readSymbolizeAndMergeCmdArguments()でシンボル化とマージ | E-01（1169-1248行目） | ○ |
| C-18 | computeStats()で統計計算 | E-01（1020-1025行目） | ○ |
| C-19 | DefaultIgnorelistStrでデフォルト無視リスト定義 | E-01（115-117行目） | ○ |
| C-20 | シンボル化処理はディスアセンブルを伴うため時間がかかる | **根拠なし（実測必要）** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンスに関するベンチマーク結果
  - 候補：テストスイート / ベンチマークドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要機能はソースコードから確認可能
- 0: 低リスク - ファイル形式（マジック/ビット幅）が明確に定義
- 1: 中リスク - パフォーマンス要件は実測が必要

## 6) レビュアーチェックリスト（最小）

- [ ] マジックナンバー（0xC0BFFFFF）が正確
- [ ] FileHeader構造体のフィールドが正確
- [ ] 各アクションの行番号が実際のコードと一致
- [ ] デフォルト無視リストの内容が正確
- [ ] 差分計算（std::set_difference）が正しく記述されている
