---
generated_at: 2026-02-01 12:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-sanstats

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/sanstats/sanstats.cpp`（1-156行目）
- E-02: `llvm/include/llvm/Transforms/Utils/SanitizerStats.h`（参照先）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（96行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sanstatsはサニタイザ統計データの処理ツールである | E-03 | ○ |
| C-02 | -fsanitize-stats形式のファイルを読み込む | E-01（9-11行目のコメント） | ○ |
| C-03 | KindFromData()で上位ビットからCFI種別を抽出 | E-01（35-37行目） | ○ |
| C-04 | CountFromData()で下位ビットから実行回数を抽出 | E-01（39-41行目） | ○ |
| C-05 | ReadLE()でリトルエンディアン形式で読込 | E-01（43-52行目） | ○ |
| C-06 | ReadModule()でモジュールごとに処理 | E-01（54-126行目） | ○ |
| C-07 | ファイル先頭1バイトがポインタサイズ | E-01（146行目） | ○ |
| C-08 | アドレス-1でシンボル化（戻りアドレス調整） | E-01（95行目、Addr - 1） | ○ |
| C-09 | アドレスとデータが両方0でモジュール終端 | E-01（84-85行目） | ○ |
| C-10 | SanStat_CFI_VCallでcfi-vcall | E-01（104-105行目） | ○ |
| C-11 | SanStat_CFI_NVCallでcfi-nvcall | E-01（106-107行目） | ○ |
| C-12 | SanStat_CFI_DerivedCastでcfi-derived-cast | E-01（108-109行目） | ○ |
| C-13 | SanStat_CFI_UnrelatedCastでcfi-unrelated-cast | E-01（110-111行目） | ○ |
| C-14 | SanStat_CFI_ICallでcfi-icall | E-01（112-113行目） | ○ |
| C-15 | --demangleオプションで関数名デマングル | E-01（31-33行目） | ○ |
| C-16 | LLVMSymbolizerでシンボル化 | E-01（71-74行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全機能がソースコードから確認可能
- 0: 低リスク - ファイル形式が明確に定義されている
- 0: 低リスク - CFI種別が全て列挙されている

## 6) レビュアーチェックリスト（最小）

- [ ] KindFromData/CountFromDataの計算式が正確
- [ ] CFI種別（5種類）が全て記述されている
- [ ] ファイル形式の説明が正確
- [ ] アドレス調整（-1）の説明が正確
- [ ] main関数の行番号が実際のコードと一致
