---
generated_at: 2026-02-01 12:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：96-llvm-stress

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-stress/llvm-stress.cpp`（1-763行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（97行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-stressはランダムなLLVM IRを生成するストレステストツール | E-02 | ○ |
| C-02 | --seedオプションでデフォルト0 | E-01（55-56行目） | ○ |
| C-03 | --sizeオプションでデフォルト100 | E-01（58-61行目） | ○ |
| C-04 | --typesで追加スカラー型指定可能 | E-01（68-71行目） | ○ |
| C-05 | --enable-scalable-vectorsでスケーラブルベクター有効化 | E-01（73-76行目） | ○ |
| C-06 | Randomクラスが乱数生成 | E-01（85-127行目） | ○ |
| C-07 | 乱数計算式が(Seed + 0x000b07a1) * 0x3c7c0ac1 | E-01（93-94行目） | ○ |
| C-08 | 19ビットマスク（0x7ffff） | E-01（96行目） | ○ |
| C-09 | GenEmptyFunction()で空関数生成 | E-01（130-148行目） | ○ |
| C-10 | 関数名がautogen_SD{シード} | E-01（144行目） | ○ |
| C-11 | デフォルト型がi1/i8/i16/i32/i64/float/double | E-01（160-163行目） | ○ |
| C-12 | FillFunction()で命令生成 | E-01（661-695行目） | ○ |
| C-13 | AllocaModifier::ActN(5)で5回alloca | E-01（687行目） | ○ |
| C-14 | ConstModifier::ActN(40)で40回定数 | E-01（688行目） | ○ |
| C-15 | IntroduceControlFlow()で制御フロー追加 | E-01（697-717行目） | ○ |
| C-16 | verifyModule()で検証 | E-01（753行目） | ○ |
| C-17 | i1ベクターのストアは生成しない | E-01（348-349行目） | ○ |
| C-18 | ベクター幅が2^((rand%3)+(rand%3)) | E-01（300行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全機能がソースコードから確認可能
- 0: 低リスク - 乱数計算式が明確に定義されている
- 0: 低リスク - 各Modifierの動作が明確

## 6) レビュアーチェックリスト（最小）

- [ ] 乱数計算式が正確に記述されている
- [ ] デフォルトのスカラー型7種類が正確
- [ ] AllocaModifier(5回)、ConstModifier(40回)が正確
- [ ] main関数の行番号が実際のコードと一致
- [ ] ベクター幅の計算式が正確
