---
generated_at: 2026-02-01 13:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-llvm-strings

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-strings/llvm-strings.cpp`（1-188行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（98行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-stringsはバイナリ内の印刷可能文字列を検索するツール | E-02 | ○ |
| C-02 | デフォルト最小文字列長は4 | E-01（71行目、MinLength = 4） | ○ |
| C-03 | radix列挙型でオフセット形式定義 | E-01（74行目） | ○ |
| C-04 | isPrint()またはタブで印刷可能判定 | E-01（116行目） | ○ |
| C-05 | MinLength未満は出力しない | E-01（93-94行目） | ○ |
| C-06 | o=8進数、d=10進数、x=16進数 | E-01（98-108行目） | ○ |
| C-07 | 標準入力は"{standard input}"と表示 | E-01（182行目） | ○ |
| C-08 | MemoryBuffer::getFileOrSTDINで読込 | E-01（177-178行目） | ○ |
| C-09 | strings()関数で文字列検出 | E-01（91-126行目） | ○ |
| C-10 | 入力ファイルなしで標準入力使用 | E-01（173-174行目） | ○ |
| C-11 | オフセット計算はS - B | E-01（120行目） | ○ |
| C-12 | ファイル読込失敗時は警告を出力して継続 | E-01（179-180行目） | ○ |
| C-13 | --bytes=0でエラー | E-01（167-170行目） | ○ |
| C-14 | フォーマット表示幅は7文字 | E-01（101, 104, 107行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全機能がソースコードから確認可能
- 0: 低リスク - シンプルな処理ロジック
- 0: 低リスク - GNU stringsとの互換性

## 6) レビュアーチェックリスト（最小）

- [ ] デフォルト最小長（4）が正確
- [ ] radix列挙型の値（none/octal/hexadecimal/decimal）が正確
- [ ] フォーマット表示幅（7文字）が正確
- [ ] isPrint()とタブ判定が正確
- [ ] main関数の行番号が実際のコードと一致
