---
generated_at: 2026-02-01 13:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-spirv-tools

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/spirv-tools/CMakeLists.txt`（1-82行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（99行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | spirv-toolsはSPIR-V操作ツール群である | E-02 | ○ |
| C-02 | LLVM_INCLUDE_SPIRV_TOOLS_TESTSはデフォルトOff | E-01（1行目） | ○ |
| C-03 | ExternalProject_AddでSPIRV-Toolsビルド | E-01（16-33行目） | ○ |
| C-04 | GitリポジトリはKhronos Group | E-01（17行目） | ○ |
| C-05 | mainブランチを追跡 | E-01（18行目） | ○ |
| C-06 | git-sync-depsで依存関係取得 | E-01（24行目） | ○ |
| C-07 | UPDATE_DISCONNECTED 1で自動更新無効 | E-01（29行目） | ○ |
| C-08 | STEP_TARGETS updateで手動更新可能 | E-01（31行目） | ○ |
| C-09 | Unix系でcreate_symlink | E-01（37行目） | ○ |
| C-10 | Windowsでcopy | E-01（39行目） | ○ |
| C-11 | spirv-dis/val/as/linkの4ツールを提供 | E-01（43-81行目） | ○ |
| C-12 | 既存バイナリ指定時はそれを使用 | E-01（43-45行目等） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - CMakeLists.txtから全設定が確認可能
- 0: 低リスク - 外部依存関係が明確
- 1: 中リスク - 外部リポジトリのmainブランチ追跡による互換性リスク

## 6) レビュアーチェックリスト（最小）

- [ ] LLVM_INCLUDE_SPIRV_TOOLS_TESTSのデフォルト値（Off）が正確
- [ ] ExternalProjectの設定が実際のCMakeLists.txtと一致
- [ ] 4ツール（spirv-dis/val/as/link）が全て記述されている
- [ ] シンボリックリンク/コピーの条件分岐が正確
- [ ] GitリポジトリURLが正確
