---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` - LLDBのCurses GUIの実装ファイル（7746行）
- E-02: `lldb/include/lldb/Core/IOHandlerCursesGUI.h` - LLDBのCurses GUIのヘッダファイル
- E-03: `IOHandlerCursesGUI.cpp` 行6312-6729 - `ApplicationDelegate`クラス（メインウィンドウのデリゲート）
- E-04: `IOHandlerCursesGUI.cpp` 行3876-4853 - `Menu`クラス（メニューバーの実装）
- E-05: `IOHandlerCursesGUI.cpp` 行6785-7239 - `SourceFileWindowDelegate`クラス（ソースビューの実装）
- E-06: `IOHandlerCursesGUI.cpp` 行5902-5968 - `FrameVariablesWindowDelegate`クラス（変数ビューの実装）
- E-07: `IOHandlerCursesGUI.cpp` 行4855-5539 - `TreeWindowDelegate`クラス（スレッドビューで使用）
- E-08: `IOHandlerCursesGUI.cpp` 行6731-6783 - `StatusBarWindowDelegate`クラス（ステータスバーの実装）
- E-09: `IOHandlerCursesGUI.cpp` 行332-356 - `HelpDialogDelegate`クラス（ヘルプダイアログの実装）
- E-10: `IOHandlerCursesGUI.cpp` 行3077-3255 - `TargetCreateFormDelegate`クラス（ターゲット作成フォームの実装）
- E-11: `IOHandlerCursesGUI.cpp` 行2909-3065 - `ProcessAttachFormDelegate`クラス（プロセスアタッチフォームの実装）
- E-12: `IOHandlerCursesGUI.cpp` 行3256-3622 - `ProcessLaunchFormDelegate`クラス（プロセス起動フォームの実装）
- E-13: `IOHandlerCursesGUI.cpp` 行2872-2907 - `DetachOrKillProcessFormDelegate`クラス（デタッチ/キル確認フォームの実装）
- E-14: `IOHandlerCursesGUI.cpp` 行5969-6310 - `RegistersWindowDelegate`クラス（レジスタビューの実装）
- E-15: `IOHandlerCursesGUI.cpp` 行3672-3875 - `SearcherWindowDelegate`クラス（検索ウィンドウの実装）
- E-16: `IOHandlerCursesGUI.cpp` 行7643-7694 - メインウィンドウ初期化コード（サブウィンドウ作成）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メインウィンドウはApplicationDelegateクラスで実装 | E-03 | ○ |
| C-02 | メニューバーはF1-F6キーでアクセス可能 | E-04 | ○ |
| C-03 | ソースビューはSourceFileWindowDelegateクラスで実装 | E-05 | ○ |
| C-04 | 変数ビューはFrameVariablesWindowDelegateクラスで実装 | E-06 | ○ |
| C-05 | スレッドビューはTreeWindowDelegateを使用 | E-07, E-16 | ○ |
| C-06 | ステータスバーはStatusBarWindowDelegateクラスで実装 | E-08 | ○ |
| C-07 | ヘルプダイアログはhキーで表示 | E-09, E-03 | ○ |
| C-08 | ターゲット作成フォームはTargetCreateFormDelegateクラスで実装 | E-10 | ○ |
| C-09 | プロセスアタッチフォームはProcessAttachFormDelegateクラスで実装 | E-11 | ○ |
| C-10 | プロセス起動フォームはProcessLaunchFormDelegateクラスで実装 | E-12 | ○ |
| C-11 | デタッチ/キル確認フォームはDetachOrKillProcessFormDelegateクラスで実装 | E-13 | ○ |
| C-12 | レジスタビューはViewメニューから表示/非表示を切り替え | E-14, E-03 | ○ |
| C-13 | ブレークポイントビューはBreakpointsTreeDelegateクラスで実装 | E-03 (行6706-6709) | ○ |
| C-14 | 検索ウィンドウはSearcherWindowDelegateクラスで実装 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての画面情報はソースコードから直接抽出されており、信頼性が高い

補足：
- 本プロジェクト（LLVM Project）は主にコマンドラインツール群で構成されており、GUIは限定的
- 唯一のGUIはLLDBデバッガのCurses GUI（テキストベースUI）のみ
- Curses GUIは `LLDB_ENABLE_CURSES` コンパイルオプションが有効な場合のみ利用可能
- WebアプリケーションやデスクトップGUIアプリケーションは存在しない

## 6) レビュアーチェックリスト（最小）
- [ ] LLDBのCurses GUIが本プロジェクトの主要なUI機能として正しく認識されているか確認
- [ ] 各画面の説明がソースコード内のクラス定義と一致しているか確認
- [ ] 画面遷移図のキーボードショートカットがソースコードの実装と一致しているか確認
- [ ] 他にUI機能が存在しないか確認（本分析では`lldb/source/Core/IOHandlerCursesGUI.cpp`のみを対象）
