# LLDB Curses GUI 画面遷移図

## 概要

本ドキュメントは、LLDB（LLVM Debugger）のCurses GUIにおける画面遷移を示します。
LLDBのCurses GUIは、ターミナル上で動作するテキストベースのデバッグインターフェースです。

## メイン画面構成

```mermaid
graph TB
    subgraph MainWindow[メインウィンドウ]
        Menubar[メニューバー]
        SourceView[ソースビュー]
        VariablesView[変数ビュー]
        ThreadsView[スレッドビュー]
        StatusBar[ステータスバー]
    end

    Menubar --> SourceView
    SourceView --> VariablesView
    SourceView --> ThreadsView
    VariablesView --> StatusBar
    ThreadsView --> StatusBar
```

## 画面遷移図

```mermaid
stateDiagram-v2
    [*] --> MainWindow: LLDBのGUIモード起動

    state MainWindow {
        [*] --> SourceView
        SourceView --> VariablesView: TABキー
        VariablesView --> ThreadsView: TABキー
        ThreadsView --> SourceView: TABキー
        SourceView --> VariablesView: Shift+TABキー
        VariablesView --> SourceView: Shift+TABキー
    }

    MainWindow --> HelpDialog: hキー
    HelpDialog --> MainWindow: ESCキー

    MainWindow --> TargetCreateForm: F2 Target > Create
    TargetCreateForm --> MainWindow: ESCキー/完了

    MainWindow --> ProcessAttachForm: F3 Process > Attach
    ProcessAttachForm --> SearchDialog: プロセス検索
    SearchDialog --> ProcessAttachForm: 選択完了
    ProcessAttachForm --> MainWindow: ESCキー/完了

    MainWindow --> ProcessLaunchForm: F3 Process > Launch
    ProcessLaunchForm --> MainWindow: ESCキー/完了

    MainWindow --> DetachKillForm: プロセス終了時
    DetachKillForm --> MainWindow: 選択完了

    MainWindow --> RegistersView: F5 View > Registers
    RegistersView --> MainWindow: F5 View > Registers (トグル)

    MainWindow --> BreakpointsView: F5 View > Breakpoints
    BreakpointsView --> MainWindow: F5 View > Breakpoints (トグル)

    MainWindow --> [*]: ESCキー/終了
```

## メニュー構造

```mermaid
graph LR
    subgraph MenuBar[メニューバー]
        LLDB[LLDB F1]
        Target[Target F2]
        Process[Process F3]
        Thread[Thread F4]
        View[View F5]
        Help[Help F6]
    end

    LLDB --> About[About]
    LLDB --> Exit[Exit]

    Target --> Create[Create]
    Target --> Delete[Delete]

    Process --> Attach[Attach]
    Process --> DetachResume[Detach Resume]
    Process --> DetachSuspended[Detach Suspended]
    Process --> Launch[Launch]
    Process --> Continue[Continue]
    Process --> Halt[Halt]
    Process --> Kill[Kill]

    Thread --> StepIn[Step In]
    Thread --> StepOver[Step Over]
    Thread --> StepOut[Step Out]

    View --> Backtrace[Backtrace]
    View --> Registers[Registers]
    View --> Source[Source]
    View --> Variables[Variables]
    View --> Breakpoints[Breakpoints]

    Help --> GUIHelp[GUI Help]
```

## キーボードショートカット

### グローバルショートカット

| キー | 動作 |
|------|------|
| TAB | 次のビューに切り替え |
| Shift+TAB | 前のビューに切り替え |
| h | ヘルプダイアログを表示 |
| ESC | アプリケーション終了 |
| F1 | LLDBメニュー |
| F2 | Targetメニュー |
| F3 | Processメニュー |
| F4 | Threadメニュー |
| F5 | Viewメニュー |
| F6 | Helpメニュー |

### ソースビューショートカット

| キー | 動作 |
|------|------|
| b | ブレークポイント設定/解除 |
| c | 実行継続 (continue) |
| n | ステップオーバー |
| N | 命令単位でステップオーバー |
| s | ステップイン |
| S | 命令単位でステップイン |
| f | ステップアウト (finish) |
| D | デタッチして停止 |
| Enter | 選択行まで実行 |
| , / Page Up | ページアップ |
| . / Page Down | ページダウン |

## ビューのレイアウト

```
+------------------------------------------------------------------+
|                        メニューバー                               |
+------------------------------------------------------------------+
|                                          |                       |
|                                          |                       |
|              ソースビュー                 |    スレッドビュー      |
|          (ソースコード/逆アセンブリ)        |   (スレッド一覧)       |
|                                          |                       |
|                                          |                       |
|                                          +-----------------------+
|                                          |                       |
+------------------------------------------+   ブレークポイント     |
|                                          |    ビュー (オプション)  |
|              変数ビュー                   |                       |
|          (ローカル変数一覧)               +-----------------------+
|                                          |                       |
+------------------------------------------+                       |
|              レジスタビュー (オプション)    |                       |
+------------------------------------------------------------------+
|                       ステータスバー                              |
+------------------------------------------------------------------+
```

## 注意事項

- LLDBのCurses GUIは `LLDB_ENABLE_CURSES` が有効な場合のみ利用可能です
- `gui` コマンドでCurses GUIモードに入ることができます
- 一部の機能はプラットフォームによって異なる場合があります
