---
generated_at: 2026-02-01 12:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` - LLDBのCurses GUI実装ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `ApplicationDelegate`クラス（行6312-6729）- メインウィンドウのイベントハンドラとメニュー処理
- E-05: `SourceFileWindowDelegate`クラス（行6785-7000+）- ソースビューの描画とキー処理
- E-06: `FrameVariablesWindowDelegate`クラス（行5902-5967）- 変数ビューの実装
- E-07: `RegistersWindowDelegate`クラス（行5969-6000+）- レジスタビューの実装
- E-08: `ThreadsTreeDelegate`クラス（行5190-5306）- スレッドビューの実装
- E-09: `StatusBarWindowDelegate`クラス（行6731-6783）- ステータスバーの実装
- E-10: `HelpDialogDelegate`クラス（行332-349, 6218-6310）- ヘルプダイアログの実装
- E-11: `TargetCreateFormDelegate`クラス（行3077-3254）- ターゲット作成フォームの実装
- E-12: `ProcessAttachFormDelegate`クラス（行2909-3075）- プロセスアタッチフォームの実装
- E-13: `ProcessLaunchFormDelegate`クラス（行3256-3644）- プロセス起動フォームの実装
- E-14: `DetachOrKillProcessFormDelegate`クラス（行2872-2907）- デタッチ/キル確認フォームの実装
- E-15: `BreakpointsTreeDelegate`クラス（行5495-5538）- ブレークポイントビューの実装
- E-16: `SearcherWindowDelegate`クラス（行3672-3818）- 検索ウィンドウの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メインウィンドウがLLDB機能の主機能として全サブウィンドウを管理 | E-01, E-04 | ○ |
| C-02 | メニューバーがF1-F6キーでLLDB/Target/Process/Thread/View/Helpメニューを表示 | E-01, E-04 | ○ |
| C-03 | ソースビューがSourceFileWindowDelegateでソースコードを表示 | E-01, E-05 | ○ |
| C-04 | ソースビューでbキーによるブレークポイント設定が可能 | E-01, E-05 | ○ |
| C-05 | ソースビューでn/N/s/S/fキーによるステップ実行が可能 | E-01, E-05 | ○ |
| C-06 | ソースビューでcキーによるプロセス続行が可能 | E-01, E-05 | ○ |
| C-07 | 変数ビューがFrameVariablesWindowDelegateでローカル変数を表示 | E-01, E-06 | ○ |
| C-08 | 変数ビューでフォーマット変更キーが使用可能 | E-01, E-06 | ○ |
| C-09 | スレッドビューがThreadsTreeDelegateでスレッド一覧を表示 | E-01, E-08 | ○ |
| C-10 | スレッドビューでスレッド選択によるコンテキスト切り替えが可能 | E-01, E-08 | ○ |
| C-11 | ステータスバーがStatusBarWindowDelegateでプロセス状態を表示 | E-01, E-09 | ○ |
| C-12 | ヘルプダイアログがHelpDialogDelegateでショートカット一覧を表示 | E-01, E-10 | ○ |
| C-13 | ターゲット作成フォームがTargetCreateFormDelegateでターゲット設定を提供 | E-01, E-11 | ○ |
| C-14 | ターゲット作成フォームのCreateボタンでターゲット作成が実行される | E-01, E-11 | ○ |
| C-15 | プロセスアタッチフォームがProcessAttachFormDelegateでアタッチ設定を提供 | E-01, E-12 | ○ |
| C-16 | プロセスアタッチフォームのAttachボタンでプロセスアタッチが実行される | E-01, E-12 | ○ |
| C-17 | プロセス起動フォームがProcessLaunchFormDelegateで起動設定を提供 | E-01, E-13 | ○ |
| C-18 | プロセス起動フォームで詳細設定（ASLR/シェル/標準入出力）が可能 | E-01, E-13 | ○ |
| C-19 | プロセス起動フォームのLaunchボタンでプロセス起動が実行される | E-01, E-13 | ○ |
| C-20 | デタッチ/キル確認フォームがDetachOrKillProcessFormDelegateで確認を提供 | E-01, E-14 | ○ |
| C-21 | レジスタビューがRegistersWindowDelegateでCPUレジスタ値を表示 | E-01, E-07 | ○ |
| C-22 | レジスタビューでフォーマット変更キーが使用可能 | E-01, E-07 | ○ |
| C-23 | ブレークポイントビューがBreakpointsTreeDelegateでブレークポイント一覧を表示 | E-01, E-15 | ○ |
| C-24 | ブレークポイントビューでロケーションの詳細展開が可能 | E-01, E-15 | ○ |
| C-25 | 検索ウィンドウがSearcherWindowDelegateでファイル/シンボル/変数検索を提供 | E-01, E-16 | ○ |
| C-26 | 全画面がLLDB機能（機能No.8）と関連している | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての画面機能マッピングはソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点: 画面一覧の全14画面は全てLLDB（機能No.8）に関連しており、LLVMプロジェクト全体の機能一覧（120機能）の中でLLDB関連の画面のみが存在する

## 6) レビュアーチェックリスト（最小）
- [ ] 画面No.1-14が画面一覧.csvのNoと一致しているか確認
- [ ] 機能No.8（LLDB）が機能一覧.csvのNo.8と一致しているか確認
- [ ] 各画面の関連種別（主機能/補助機能/遷移先機能）が適切か確認
- [ ] 「関連する操作・処理」の説明がソースコードの実装と整合しているか確認
