# 画面設計書 1-メインウィンドウ

## 概要

本ドキュメントは、LLDB（LLVM Debugger）のCurses GUIにおけるメインウィンドウの画面設計を記載する。メインウィンドウは、デバッガのCurses GUIの最上位コンテナとして機能し、すべてのサブウィンドウ（メニューバー、ソースビュー、変数ビュー、スレッドビュー、ステータスバー）を管理する。

### 本画面の処理概要

メインウィンドウは、LLDBデバッガのテキストベースGUIインターフェースの中核となる画面であり、ターミナル上でデバッグ作業を効率的に行うための統合環境を提供する。

**業務上の目的・背景**：ターミナル環境でのデバッグ作業において、GUIベースのIDEと同等の視覚的なデバッグ体験を提供する。特にSSH経由でのリモートデバッグやヘッドレス環境での開発において、ncurses ライブラリを用いたテキストベースGUIにより、効率的なデバッグ操作を実現する。複数の情報（ソースコード、変数、スレッド状態）を同時に視認しながらデバッグ作業を進められる。

**画面へのアクセス方法**：LLDBコマンドラインから `gui` コマンドを実行することでCurses GUIモードに入り、メインウィンドウが表示される。`LLDB_ENABLE_CURSES` が有効な状態でビルドされたLLDBでのみ利用可能。

**主要な操作・処理内容**：
1. TABキーによる各サブウィンドウ（ソースビュー、変数ビュー、スレッドビュー）間のフォーカス切り替え
2. F1〜F6キーによるメニューバーへのアクセスとメニュー操作
3. hキーによるヘルプダイアログの表示
4. ESCキーによるアプリケーション終了
5. サブウィンドウの動的な追加・削除（レジスタビュー、ブレークポイントビューのトグル表示）
6. キーボード入力のサブウィンドウへの配信とイベント処理

**画面遷移**：
- この画面からの遷移先：ヘルプダイアログ（hキー）、ターゲット作成フォーム（F2→Create）、プロセスアタッチフォーム（F3→Attach）、プロセス起動フォーム（F3→Launch）、デタッチ/キル確認フォーム（プロセス終了時）
- この画面への遷移元：LLDBコマンドラインから `gui` コマンド実行時

**権限による表示制御**：権限による表示制御は存在しない。ただし、プロセスの状態（実行中、停止中、終了）によって一部の操作が無効化される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | LLDBデバッガのCurses GUIメインウィンドウ。全サブウィンドウの管理とApplicationDelegateによるキーボード入力処理 |

## 画面種別

メイン画面（コンテナ）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

LLDBコマンドラインから `gui` コマンドで起動。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| キーボード入力 | 入力 | int | キーコード（TAB、ESC、h、F1〜F6等） |
| ウィンドウサイズ | 入力 | Size | ターミナルウィンドウのサイズ（width, height） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| メニューバー | 画面最上部（1行） | LLDB/Target/Process/Thread/View/Helpメニュー |
| ソースビュー | 画面左側（メニューバー下） | ソースコードまたは逆アセンブリ表示 |
| スレッドビュー | 画面右上 | スレッド一覧とスタックフレーム表示 |
| 変数ビュー | 画面左下 | ローカル変数一覧 |
| ステータスバー | 画面最下部（1行） | プロセス状態、スレッドID、フレーム情報 |
| レジスタビュー | 画面左下（オプション） | CPUレジスタ値表示（Viewメニューでトグル） |
| ブレークポイントビュー | 画面右下（オプション） | ブレークポイント一覧（Viewメニューでトグル） |

## イベント仕様

### 1-TABキー押下

アクティブなサブウィンドウを次のサブウィンドウに切り替える。

- 処理：`Window::SelectNextWindowAsActive()` メソッドを呼び出し
- フォーカス順序：ソースビュー → 変数ビュー → スレッドビュー → ソースビュー（循環）

### 2-Shift+TABキー押下

アクティブなサブウィンドウを前のサブウィンドウに切り替える。

- 処理：`Window::SelectPreviousWindowAsActive()` メソッドを呼び出し
- フォーカス順序：TABキーの逆順

### 3-hキー押下

ヘルプダイアログを表示する。

- 処理：`Window::CreateHelpSubwindow()` メソッドを呼び出し
- HelpDialogDelegateが生成され、現在のウィンドウのキーボードショートカット一覧を表示

### 4-ESCキー押下

アプリケーションを終了する。

- 処理：`eQuitApplication` を返却し、GUIモードを終了
- LLDBコマンドラインに戻る

### 5-F1〜F6キー押下

対応するメニューを開く。

- F1：LLDBメニュー（About、Exit）
- F2：Targetメニュー（Create、Delete）
- F3：Processメニュー（Attach、Launch、Continue等）
- F4：Threadメニュー（Step In、Step Over、Step Out）
- F5：Viewメニュー（Backtrace、Registers、Source等）
- F6：Helpメニュー（GUI Help）

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | "Welcome to the LLDB curses GUI." | ヘルプダイアログ表示時 |
| MSG-002 | 情報 | "Press the TAB key to change the selected view." | ヘルプダイアログ表示時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ターミナルサイズ不足 | 最小サイズに達しない場合、ウィンドウの描画が不完全になる可能性がある |
| ncursesライブラリ未対応 | LLDB_ENABLE_CURSESが無効な場合、`gui` コマンドが利用不可 |

## 備考

- メインウィンドウは `ApplicationDelegate` クラスで実装されている
- `WindowDelegate` と `MenuDelegate` の両方を継承し、ウィンドウイベントとメニューイベントの両方を処理
- サブウィンドウのレイアウトは `Rect` 構造体の `HorizontalSplit`、`VerticalSplit` メソッドで分割

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メインウィンドウの基盤となるデータ構造（Point、Size、Rect）を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 119-262行：Point、Size、Rect構造体。ウィンドウの位置とサイズを管理 |
| 1-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 272-287行：HandleCharResult、MenuActionResult列挙型。イベント処理結果の定義 |

**読解のコツ**: C++のncursesラッパークラスとして実装されている。Rectの `MakeStatusBar`、`MakeMenuBar`、`HorizontalSplit`、`VerticalSplit` メソッドがレイアウト分割の核心。

#### Step 2: エントリーポイントを理解する

Application クラスがCurses GUIのエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6312-6403行：ApplicationDelegateクラスの定義。メニューIDの列挙型とキーハンドリング |

**主要処理フロー**:
1. **6348-6349行**: コンストラクタでDebuggerへの参照を保持
2. **6357-6378行**: `WindowDelegateHandleChar` でTAB、Shift+TAB、h、ESCキーを処理
3. **6405-6511行**: `MenuDelegateAction` でメニュー選択時のアクションを処理

#### Step 3: Windowクラスを理解する

サブウィンドウを管理するWindowクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 574-624行：Windowクラスのコンストラクタとデストラクタ |
| 3-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 315-330行：WindowDelegateインターフェースの定義 |

**主要処理フロー**:
- **574行**: Window クラスは Surface クラスを継承
- **580行**: `m_curr_active_window_idx` でアクティブなサブウィンドウを追跡

#### Step 4: Surfaceクラス（描画基盤）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 355-500行：Surfaceクラス。ncursesのWINDOWをラップし、描画操作を抽象化 |

**主要処理フロー**:
- **402-445行**: Clear、Erase、PutChar、PutCString、Printf等の描画メソッド
- **447-485行**: Box、TitledBox等のウィンドウ枠描画メソッド

### プログラム呼び出し階層図

```
IOHandler::Run() [GUI起動]
    │
    ├─ Application::Run()
    │      │
    │      ├─ Window::Draw() [メインウィンドウ描画]
    │      │      └─ ApplicationDelegate::WindowDelegateDraw()
    │      │
    │      └─ Window::HandleChar() [キー入力処理]
    │             │
    │             ├─ ApplicationDelegate::WindowDelegateHandleChar()
    │             │      ├─ Window::SelectNextWindowAsActive() [TAB]
    │             │      ├─ Window::SelectPreviousWindowAsActive() [Shift+TAB]
    │             │      ├─ Window::CreateHelpSubwindow() [h]
    │             │      └─ return eQuitApplication [ESC]
    │             │
    │             └─ Menu::WindowDelegateHandleChar() [F1-F6]
    │                    └─ ApplicationDelegate::MenuDelegateAction()
    │                           ├─ TargetCreateFormDelegate [Create Target]
    │                           ├─ ProcessAttachFormDelegate [Attach Process]
    │                           └─ ProcessLaunchFormDelegate [Launch Process]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

キーボード入力 ─────────▶ ApplicationDelegate              ┌─▶ サブウィンドウ切替
(TAB/ESC/h/F1-F6)         ::WindowDelegateHandleChar()  ───┼─▶ ヘルプダイアログ表示
                                                           ├─▶ メニュー操作
                                                           └─▶ アプリケーション終了

ターミナルサイズ ────────▶ Rect::HorizontalSplit()        ─▶ サブウィンドウレイアウト
                          Rect::VerticalSplit()

Debugger状態 ────────────▶ ExecutionContext               ─▶ ステータスバー更新
                          ::GetProcessPtr()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | Curses GUI実装の本体。全ての画面クラスを含む |
| IOHandlerCursesGUI.h | `lldb/include/lldb/Core/IOHandlerCursesGUI.h` | ヘッダ | IOHandlerCursesGUIクラスの宣言 |
| Debugger.h | `lldb/include/lldb/Core/Debugger.h` | ヘッダ | デバッガコアクラスの宣言 |
| Config.h | `lldb/include/lldb/Host/Config.h` | ヘッダ | LLDB_ENABLE_CURSES マクロ定義 |
