# 画面設計書 10-プロセス起動フォーム

## 概要

本ドキュメントは、LLDB Curses GUIにおけるプロセス起動フォームの画面設計を記載する。プロセス起動フォームは、デバッグターゲットのプロセスを起動するための設定フォームダイアログである。

### 本画面の処理概要

プロセス起動フォームは、作成済みのデバッグターゲットからプロセスを起動（Launch）するための設定を行うダイアログである。

**業務上の目的・背景**：デバッグ対象プログラムを最初から実行してデバッグする場合、適切なコマンドライン引数、環境変数、ワーキングディレクトリを設定してプロセスを起動する必要がある。このフォームでは、これらの基本設定に加え、ASLR無効化、シェル指定、標準入出力のリダイレクトなどの詳細設定も提供する。

**画面へのアクセス方法**：メニューバーから F3（Process） > Launch を選択することで表示される。

**主要な操作・処理内容**：
1. コマンドライン引数の入力
2. ターゲット環境変数の設定
3. ワーキングディレクトリの指定
4. エントリポイント停止オプション
5. エラー時デタッチオプション
6. ASLR無効化オプション
7. シェル指定（詳細設定）
8. 標準入出力のリダイレクト設定（詳細設定）
9. 継承する環境変数の設定（詳細設定）
10. Launchボタンでプロセス起動

**画面遷移**：
- この画面からの遷移先：メインウィンドウ（起動成功時）、デタッチ/キル確認フォーム（既存プロセス実行中時）
- この画面への遷移元：メニューバー > Process > Launch

**権限による表示制御**：権限による表示制御は存在しない。ただし、実行中のプロセスがある場合はデタッチ/キル確認フォームが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | ProcessLaunchFormDelegateによるプロセス起動設定。引数/環境変数/ワーキングディレクトリの設定 |
| 8 | LLDB | 補助機能 | 詳細設定によるASLR無効化/シェル指定/標準入出力設定 |
| 8 | LLDB | 遷移先機能 | Launchボタンによるプロセス起動。Target::Launchメソッドの呼び出し |

## 画面種別

フォームダイアログ（モーダル）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Arguments | 入力 | 引数リスト | オプション | コマンドライン引数 |
| Target Environment Variables | 入力 | 環境変数リスト | オプション | ターゲット環境変数 |
| Working Directory | 入力 | ディレクトリパス | オプション | ワーキングディレクトリ |
| Show advanced settings | 入力 | ブール | - | 詳細設定の表示/非表示 |
| Stop at entry point | 入力 | ブール | - | エントリポイントで停止（詳細） |
| Detach on error | 入力 | ブール | - | エラー時デタッチ（詳細） |
| Disable ASLR | 入力 | ブール | - | ASLR無効化（詳細） |
| Process Plugin | 入力 | 選択リスト | オプション | プロセスプラグイン（詳細） |
| Architecture | 入力 | 文字列 | オプション | アーキテクチャ指定（詳細） |
| Shell | 入力 | ファイルパス | オプション | シェルパス（詳細） |
| Expand shell arguments | 入力 | ブール | - | シェル引数展開（詳細） |
| Disable Standard IO | 入力 | ブール | - | 標準入出力無効化（詳細） |
| Standard Output File | 入力 | ファイルパス | オプション | 標準出力リダイレクト先（詳細） |
| Standard Error File | 入力 | ファイルパス | オプション | 標準エラーリダイレクト先（詳細） |
| Standard Input File | 入力 | ファイルパス | オプション | 標準入力リダイレクト元（詳細） |
| Show inherited environment | 入力 | ブール | - | 継承環境変数表示（詳細） |
| Inherited Environment Variables | 入力 | 環境変数リスト | オプション | 継承する環境変数（詳細） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| フォームタイトル | ダイアログ上部 | "Launch Process" |
| Argumentsフィールド | フォーム上部 | 引数入力 |
| Target Environment Variablesフィールド | Argumentsの下 | 環境変数リスト |
| Working Directoryフィールド | 環境変数の下 | ディレクトリパス入力 |
| Show advanced settingsチェックボックス | 基本設定の下 | 詳細設定トグル |
| Stop at entry pointチェックボックス | 詳細設定領域 | エントリ停止フラグ |
| Detach on errorチェックボックス | 詳細設定領域 | エラー時デタッチフラグ |
| Disable ASLRチェックボックス | 詳細設定領域 | ASLR無効化フラグ |
| Process Pluginフィールド | 詳細設定領域 | プラグイン選択 |
| Architectureフィールド | 詳細設定領域 | アーキテクチャ入力 |
| Shellフィールド | 詳細設定領域 | シェルパス入力 |
| Expand shell argumentsチェックボックス | 詳細設定領域 | シェル引数展開フラグ |
| Disable Standard IOチェックボックス | 詳細設定領域 | 標準IO無効化フラグ |
| Standard Output/Error/Inputフィールド | 詳細設定領域 | 標準入出力設定 |
| Inherited Environment Variablesフィールド | 詳細設定領域 | 継承環境変数リスト |
| Launchボタン | フォーム下部 | プロセス起動アクション |
| エラーメッセージ | フォーム下部 | バリデーション/実行エラー表示 |

## イベント仕様

### 1-Show advanced settings チェック変更

詳細設定フィールドの表示/非表示を切り替える。

- 処理：UpdateFieldsVisibility() が呼び出される（3305-3350行）
- チェックON：全ての詳細設定フィールドを表示
- チェックOFF：詳細設定フィールドを非表示

### 2-Disable Standard IO チェック変更

標準入出力フィールドの表示/非表示を切り替える。

- チェックON：Standard Output/Error/Input フィールドを非表示
- チェックOFF：Standard Output/Error/Input フィールドを表示

### 3-Show inherited environment variables チェック変更

継承環境変数フィールドの表示/非表示を切り替える。

### 4-Launchボタン押下

プロセスを起動する。

- 処理：Launch(Window &window) が呼び出される
- フロー：
  1. 実行中のプロセスがある場合、デタッチ/キル確認フォームを表示
  2. フィールドのバリデーションチェック
  3. ProcessLaunchInfo を構築
  4. Target::Launch() でプロセス起動
  5. 成功時：ダイアログを閉じる
  6. 失敗時：エラーメッセージを表示

## データベース更新仕様

該当なし（データベースは使用しない）

LLDB内部データ構造の更新：
| 操作 | 対象 | 概要 |
|-----|------|------|
| Target::Launch | Target | プロセスの起動 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 警告 | "There is a running process, either detach or kill it." | 実行中プロセス存在時 |
| MSG-002 | エラー | "{Status::AsCString()}" | 起動失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 実行中のプロセスがある | デタッチ/キル確認フォームを表示 |
| ターゲットが設定されていない | エラーメッセージを表示 |
| 実行ファイルがない | エラーメッセージを表示 |
| 起動失敗 | エラーメッセージを表示 |

## 備考

- ProcessLaunchFormDelegateクラスで実装
- FormDelegateを継承してフォーム機能を利用
- デフォルト値はターゲット設定から取得
- 詳細設定は初期状態で非表示
- ProcessLaunchInfo構造体に起動設定を格納

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ProcessLaunchFormDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3256-3350行：ProcessLaunchFormDelegateクラス定義前半 |

**読解のコツ**: 詳細設定フィールドが多く、UpdateFieldsVisibilityでの表示制御が複雑。

#### Step 2: フィールド初期化を理解する

コンストラクタでのフィールド設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3257-3301行：コンストラクタ（フィールド追加） |

**主要処理フロー**:
1. **3261-3267行**: Arguments、環境変数、ワーキングディレクトリ追加
2. **3269-3280行**: 詳細設定チェックボックス追加
3. **3282-3292行**: 標準入出力フィールド追加
4. **3294-3298行**: 継承環境変数フィールド追加
5. **3300行**: Launchボタン追加

#### Step 3: 表示制御を理解する

UpdateFieldsVisibility メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3305-3350行：UpdateFieldsVisibility実装 |

**主要処理フロー**:
- **3306-3328行**: Show advanced settings = true時の表示制御
- **3315-3323行**: Disable Standard IO による標準入出力フィールドの表示制御
- **3324-3328行**: Show inherited environment による環境変数フィールドの表示制御
- **3329-3350行**: Show advanced settings = false時の非表示処理

### プログラム呼び出し階層図

```
ApplicationDelegate::MenuDelegateAction(eMenuID_ProcessLaunch)
    │
    └─ ProcessLaunchFormDelegate コンストラクタ
           │
           ├─ AddArgumentsField()
           ├─ AddEnvironmentVariableListField() [Target/Inherited]
           ├─ AddDirectoryField() [Working Directory]
           ├─ AddBooleanField() [Stop/Detach/ASLR/DisableIO/etc.]
           ├─ AddProcessPluginField()
           ├─ AddArchField()
           ├─ AddFileField() [Shell/StdOut/StdErr/StdIn]
           └─ AddAction("Launch", Launch)

Launch(Window &window)
    │
    ├─ StopRunningProcess()
    │      └─ [実行中プロセスあり] DetachOrKillProcessFormDelegate表示
    │
    ├─ CheckFieldsValidity() [バリデーション]
    │
    ├─ GetProcessLaunchInfo()
    │      └─ ProcessLaunchInfo構築
    │
    ├─ Target::Launch()
    │      └─ プロセス起動
    │
    └─ [成功] window.GetParent()->RemoveSubWindow()
```

### データフロー図

```
[入力]                           [処理]                           [出力]

Arguments ─────────────────────▶ ProcessLaunchFormDelegate     ─▶ ProcessLaunchInfo
Target Environment Variables     ::GetProcessLaunchInfo()
Working Directory

Stop at entry point ───────────▶ SetLaunchFlags()              ─▶ LaunchFlags

Disable ASLR ──────────────────▶ SetDisableASLR()              ─▶ ASLR設定

Standard Output/Error/Input ───▶ SetStdIOFileAction()          ─▶ リダイレクト設定

                                 Target::Launch()               ─▶ ProcessSP
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | ProcessLaunchFormDelegateの実装 |
| ProcessLaunchInfo.h | `lldb/include/lldb/Target/ProcessLaunchInfo.h` | ヘッダ | 起動情報構造体 |
| Target.h | `lldb/include/lldb/Target/Target.h` | ヘッダ | ターゲットクラス（Launchメソッド） |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダ | プロセスクラス |
