# 画面設計書 11-デタッチ/キル確認フォーム

## 概要

本ドキュメントは、LLDB Curses GUIにおけるデタッチ/キル確認フォームの画面設計を記述したものである。

### 本画面の処理概要

本画面は、デバッグ中のプロセスを終了する際に、プロセスのデタッチ（切り離し）またはキル（強制終了）を選択するための確認ダイアログである。

**業務上の目的・背景**：デバッグセッション中に、新しいターゲットへのアタッチやプロセスの起動を行う場合、現在実行中のプロセスを適切に処理する必要がある。プロセスをデタッチすると、プロセスは独立して実行を継続し、キルすると完全に終了する。この選択により、デバッガの操作ミスによる意図しないプロセス終了を防ぎ、ユーザーに明示的な確認を求めることで安全なデバッグワークフローを実現する。

**画面へのアクセス方法**：この画面は自動的に表示される。以下の操作時に実行中のプロセスが存在する場合に表示される：
- プロセスアタッチフォーム（F3 > Process > Attach）でアタッチ操作を実行しようとした場合
- プロセス起動フォーム（F3 > Process > Launch）で起動操作を実行しようとした場合

**主要な操作・処理内容**：
1. フォーム表示時に「There is a running process, either detach or kill it.」というエラーメッセージが表示される
2. 「Keep process stopped when detaching」チェックボックスでデタッチ時のプロセス状態を指定
3. 「Detach」ボタンでプロセスをデタッチ（プロセスは実行継続または停止状態で独立）
4. 「Kill」ボタンでプロセスを強制終了

**画面遷移**：
- 遷移元：プロセスアタッチフォーム、プロセス起動フォーム（実行中プロセスがある場合に自動表示）
- 遷移先：Detach/Kill操作完了後、呼び出し元のフォームに戻る

**権限による表示制御**：特になし。プロセスが実行中の場合にのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | DetachOrKillProcessFormDelegateによるプロセス終了確認。デタッチまたはキルの選択 |

## 画面種別

確認ダイアログ

## URL/ルーティング

該当なし（Curses GUI内部のサブウィンドウとして表示）

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 初期値 | 説明 |
|--------|----------|----------|------|--------|------|
| Keep process stopped when detaching | チェックボックス | Boolean | - | false | デタッチ時にプロセスを停止状態で維持するかどうか |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトル | ウィンドウ上部 | "Detach/Kill Process" |
| エラーメッセージ | フォーム上部 | "There is a running process, either detach or kill it." |
| Keep process stopped when detaching | 入力フィールド | デタッチオプションのチェックボックス |
| Detach ボタン | フォーム下部 | プロセスデタッチ実行ボタン |
| Kill ボタン | フォーム下部 | プロセスキル実行ボタン |

## イベント仕様

### 1-Detachボタン押下

1. `m_keep_stopped_field->GetBoolean()`でデタッチオプションを取得
2. `m_process->Detach(keep_stopped)`を呼び出してプロセスをデタッチ
3. 成功時：親ウィンドウからサブウィンドウを削除
4. 失敗時：「Failed to detach from process.」エラーメッセージを表示

### 2-Killボタン押下

1. `m_process->Destroy(false)`を呼び出してプロセスを強制終了
2. 成功時：親ウィンドウからサブウィンドウを削除
3. 失敗時：「Failed to kill process.」エラーメッセージを表示

## データベース更新仕様

該当なし（データベースを使用しないデバッガアプリケーション）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|--------------|------|---------------|----------|
| MSG-001 | 警告 | There is a running process, either detach or kill it. | フォーム表示時（常時） |
| MSG-002 | エラー | Failed to detach from process. | Detach操作失敗時 |
| MSG-003 | エラー | Failed to kill process. | Kill操作失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| デタッチ失敗 | Status::Fail()がtrueの場合、エラーメッセージを表示しフォームを維持 |
| キル失敗 | Status::Fail()がtrueの場合、エラーメッセージを表示しフォームを維持 |

## 備考

- ウィンドウサイズは85x8で中央に配置される（`GetCenteredRect(85, 8)`）
- FormDelegateを継承した標準的なフォーム構造を使用
- ProcessAttachFormDelegateおよびProcessLaunchFormDelegateのStopRunningProcess()メソッドから呼び出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造と基底クラスを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行2288-2387: FormDelegateクラスの定義。フィールドの追加メソッドとアクションの管理方法を理解 |

**読解のコツ**: FormDelegateはフォーム画面の基底クラス。AddBooleanField()でチェックボックスを追加し、AddAction()でボタンを追加する。

#### Step 2: エントリーポイントを理解する

DetachOrKillProcessFormDelegateがどこで生成されるかを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行2967-2988: ProcessAttachFormDelegate::StopRunningProcess()での生成 |
| 2-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行3546-3567: ProcessLaunchFormDelegate::StopRunningProcess()での生成 |

**主要処理フロー**:
1. **行2974-2976**: 実行中のプロセスの存在チェック
2. **行2978-2979**: DetachOrKillProcessFormDelegateのインスタンス生成
3. **行2980**: GetCenteredRect(85, 8)でウィンドウ位置を計算
4. **行2981-2985**: サブウィンドウの作成とデリゲートの設定

#### Step 3: DetachOrKillProcessFormDelegateクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行2872-2907: DetachOrKillProcessFormDelegateクラス全体 |

**主要処理フロー**:
- **行2874-2882**: コンストラクタ - エラーメッセージ設定、フィールドとアクション追加
- **行2884**: GetName() - フォームタイトル「Detach/Kill Process」を返す
- **行2886-2893**: Kill() - プロセス強制終了処理
- **行2895-2902**: Detach() - プロセスデタッチ処理
- **行2905-2906**: メンバ変数 - Processポインタとチェックボックスフィールド

### プログラム呼び出し階層図

```
ProcessAttachFormDelegate::Attach() / ProcessLaunchFormDelegate::Launch()
    |
    +-- StopRunningProcess()
            |
            +-- exe_ctx.GetProcessPtr() [プロセス存在チェック]
            |
            +-- new DetachOrKillProcessFormDelegate(process)
                    |
                    +-- SetError("There is a running process...")
                    +-- AddBooleanField("Keep process stopped...")
                    +-- AddAction("Detach", ...)
                    +-- AddAction("Kill", ...)
            |
            +-- CreateSubWindow() [サブウィンドウ作成]
            |
            +-- SetDelegate(new FormWindowDelegate(...))

[ユーザー操作]
    |
    +-- Detach() ボタン押下
    |       |
    |       +-- m_process->Detach(keep_stopped)
    |       +-- window.GetParent()->RemoveSubWindow(&window)
    |
    +-- Kill() ボタン押下
            |
            +-- m_process->Destroy(false)
            +-- window.GetParent()->RemoveSubWindow(&window)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Process* (実行中プロセス) ------> DetachOrKillProcessFormDelegate --> プロセス状態変更
                                        |
                                        +-- Detach操作
                                        |     |
                                        |     +-- Process::Detach() --> プロセスデタッチ
                                        |
                                        +-- Kill操作
                                              |
                                              +-- Process::Destroy() --> プロセス終了

ユーザー入力 ------------------> BooleanFieldDelegate -------------> デタッチオプション
(Keep stopped チェック)               (m_keep_stopped_field)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | DetachOrKillProcessFormDelegate実装（行2872-2907）、呼び出し元のStopRunningProcess実装 |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダー | Process::Detach()、Process::Destroy()のインターフェース定義 |
| Status.h | `lldb/include/lldb/Utility/Status.h` | ヘッダー | 操作結果のエラーハンドリング用Status型 |
