# 画面設計書 13-ブレークポイントビュー

## 概要

本ドキュメントは、LLDB Curses GUIにおけるブレークポイントビューの画面設計を記述したものである。

### 本画面の処理概要

本画面は、設定されているブレークポイントの一覧を階層的に表示するウィンドウである。各ブレークポイントとその配下のロケーション情報を展開可能なツリー形式で表示し、モジュール、関数、アドレス、ヒットカウントなどの詳細情報を確認できる。

**業務上の目的・背景**：デバッグ作業において、ブレークポイントの管理は極めて重要である。複数のブレークポイントを設定している場合、どこにどのようなブレークポイントが設定されているかを一覧で確認し、各ブレークポイントの解決状態（resolved）、ハードウェアブレークポイントかどうか、ヒットカウントなどの詳細情報を把握することで、効率的なデバッグワークフローを実現する。また、条件付きブレークポイントや間接ブレークポイントの設定状況も確認できる。

**画面へのアクセス方法**：
- F5キーを押してViewメニューを開き、「Breakpoints」を選択
- または、Viewメニューから「Breakpoints」をクリック

**主要な操作・処理内容**：
1. ブレークポイント一覧の表示（ルートレベルに「Breakpoints」、子レベルに各ブレークポイント）
2. ブレークポイントを展開してロケーション情報を確認
3. ロケーションをさらに展開して詳細情報（モジュール、コンパイルユニット、関数、アドレス、解決状態、ヒットカウント）を確認
4. 上下矢印キーで項目を選択
5. 左右矢印キーまたはスペースキーで展開/折りたたみ

**画面遷移**：
- 遷移元：メインウィンドウ（F5 > View > Breakpoints）
- 遷移先：F5 > View > Breakpointsで再度選択するとウィンドウが閉じる（トグル動作）

**権限による表示制御**：特になし。ターゲットが選択されている場合にのみ内容が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | BreakpointsTreeDelegateによるブレークポイント一覧表示。設定済みブレークポイントの詳細情報表示 |
| 8 | LLDB | 補助機能 | ブレークポイントロケーションの展開表示。モジュール/関数/アドレスの詳細確認 |

## 画面種別

一覧（ツリー形式）

## URL/ルーティング

該当なし（Curses GUI内部のサブウィンドウとして表示）

## 入出力項目

本画面は表示専用であり、入力項目はない。キーボードによるナビゲーションと展開/折りたたみ操作のみ。

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトル | ウィンドウ上部 | "Breakpoints" |
| ルートノード | ツリーのルート | "Breakpoints"テキスト |
| ブレークポイント | 第1階層 | `{ID}: {resolver_description} {filter_description}` |
| ロケーション | 第2階層 | `{bp_id}.{loc_id}: {resolved_address}` |
| 詳細情報 | 第3階層（展開時） | module, compile unit, function, location, symbol, address, resolved, hardware, hit count |

### 詳細情報の内訳

| 情報名 | フォーマット | 説明 |
|--------|-------------|------|
| module | `module = {module_file_spec}` | 所属モジュール |
| compile unit | `compile unit = {filename}` | コンパイルユニット |
| function | `function = {function_name}` | 関数名 |
| location | `location = {line_entry}` | ソースファイル位置 |
| symbol | `symbol = {symbol_name}` | シンボル名（関数がない場合） |
| re-exported target | `re-exported target = {symbol_name}` | 再エクスポートターゲット |
| address | `{load_address} ({module_with_file_address})` | アドレス情報 |
| indirect target | `indirect target = {resolved_symbol}` | 間接ブレークポイントの解決先 |
| resolved | `resolved = true/false` | 解決状態 |
| hardware | `hardware = true/false` | ハードウェアブレークポイントかどうか |
| hit count | `hit count = {count}` | ヒット回数 |

## イベント仕様

### 1-展開/折りたたみ操作

1. 右矢印キー：選択項目を展開
2. 左矢印キー：折りたたみ、または親項目へ移動
3. スペースキー：展開/折りたたみをトグル

### 2-ナビゲーション操作

1. 上矢印キー：前の項目を選択
2. 下矢印キー：次の項目を選択

### 3-TreeDelegateShouldDraw

- ターゲットが選択されていない場合はfalseを返し、描画をスキップ

### 4-TreeDelegateGenerateChildren（BreakpointsTreeDelegate）

1. 選択されたターゲットからBreakpointListを取得
2. BreakpointListのミューテックスをロック
3. BreakpointTreeDelegateを使用して各ブレークポイントのツリー項目を生成

### 5-TreeDelegateGenerateChildren（BreakpointTreeDelegate）

1. ブレークポイントからロケーション数を取得
2. BreakpointLocationTreeDelegateを使用して各ロケーションのツリー項目を生成

### 6-TreeDelegateGenerateChildren（BreakpointLocationTreeDelegate）

1. ブレークポイントロケーションからSymbolContextを計算
2. ComputeDetailsList()で詳細情報リストを生成
3. TextTreeDelegateを使用して詳細テキストを表示

## データベース更新仕様

該当なし（データベースを使用しないデバッガアプリケーション）

## メッセージ仕様

特になし。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ターゲット未選択 | TreeDelegateShouldDraw()がfalseを返し、描画をスキップ |
| ブレークポイントなし | 空のツリーを表示 |

## 備考

- TreeDelegateを継承した3層の階層構造：
  - BreakpointsTreeDelegate（ルート）
  - BreakpointTreeDelegate（各ブレークポイント）
  - BreakpointLocationTreeDelegate（各ロケーション）
- ルートノードはデフォルトで展開（TreeDelegateExpandRootByDefault()がtrueを返す）
- スレッドウィンドウの下部にブレークポイントウィンドウを配置（HorizontalSplitPercentage 0.70）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、3層のTreeDelegate階層構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5495-5538: BreakpointsTreeDelegateクラス（ルートレベル） |
| 1-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5449-5493: BreakpointTreeDelegateクラス（ブレークポイントレベル） |
| 1-3 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5308-5447: BreakpointLocationTreeDelegateクラス（ロケーションレベル） |

**読解のコツ**: 各TreeDelegateは以下の責務を持つ：
- TreeDelegateShouldDraw(): 描画すべきかの判定
- TreeDelegateDrawTreeItem(): 項目のテキスト描画
- TreeDelegateGenerateChildren(): 子項目の生成

#### Step 2: エントリーポイントを理解する

BreakpointsTreeDelegateがどこで生成されるかを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行6682-6712: eMenuID_ViewBreakpointsのメニューハンドラ |

**主要処理フロー**:
1. **行6683-6686**: 既存のBreakpointsウィンドウとThreadsウィンドウを検索
2. **行6694-6698**: 既存ウィンドウがあれば削除しThreadsウィンドウを拡大
3. **行6699-6709**: 新規ウィンドウ作成とBreakpointsTreeDelegateの設定
4. **行6701**: HorizontalSplitPercentage(0.70)でレイアウト計算

#### Step 3: BreakpointsTreeDelegateを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5495-5538: BreakpointsTreeDelegateクラス |

**主要処理フロー**:
- **行5502-5508**: TreeDelegateShouldDraw() - ターゲットが選択されているか確認
- **行5510-5512**: TreeDelegateDrawTreeItem() - 「Breakpoints」を表示
- **行5514-5528**: TreeDelegateGenerateChildren() - ブレークポイントリストから子項目生成
- **行5533**: TreeDelegateExpandRootByDefault() - デフォルトで展開

#### Step 4: BreakpointTreeDelegateを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5449-5493: BreakpointTreeDelegateクラス |

**主要処理フロー**:
- **行5457-5461**: GetBreakpoint() - BreakpointListからブレークポイントを取得
- **行5463-5470**: TreeDelegateDrawTreeItem() - `{ID}: {resolver} {filter}`形式で表示
- **行5472-5484**: TreeDelegateGenerateChildren() - ロケーションから子項目生成

#### Step 5: BreakpointLocationTreeDelegateを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 行5308-5447: BreakpointLocationTreeDelegateクラス |

**主要処理フロー**:
- **行5321-5324**: GetBreakpointLocation() - ロケーションを取得
- **行5326-5336**: TreeDelegateDrawTreeItem() - `{bp_id}.{loc_id}: {address}`形式で表示
- **行5338-5427**: ComputeDetailsList() - 詳細情報リストを計算
- **行5429-5440**: TreeDelegateGenerateChildren() - 詳細テキストから子項目生成

### プログラム呼び出し階層図

```
ApplicationDelegate::MenuActionResult() [eMenuID_ViewBreakpoints]
    |
    +-- FindSubWindow("Breakpoints") [既存ウィンドウチェック]
    |
    +-- [既存ウィンドウあり]
    |       |
    |       +-- threads_window_sp->Resize() [Threadsウィンドウを拡大]
    |       +-- RemoveSubWindow() [Breakpointsウィンドウ削除]
    |
    +-- [既存ウィンドウなし]
            |
            +-- HorizontalSplitPercentage(0.70) [レイアウト計算]
            |
            +-- CreateSubWindow("Breakpoints", ...) [ウィンドウ作成]
            |
            +-- new BreakpointsTreeDelegate(m_debugger)
            |
            +-- new TreeWindowDelegate(debugger, breakpoints_delegate_sp)

[描画時]
BreakpointsTreeDelegate
    |
    +-- TreeDelegateShouldDraw()
    |       |
    |       +-- debugger.GetSelectedTarget() [ターゲット確認]
    |
    +-- TreeDelegateDrawTreeItem() --> "Breakpoints"
    |
    +-- TreeDelegateGenerateChildren()
            |
            +-- target->GetBreakpointList()
            |
            +-- BreakpointTreeDelegate [各ブレークポイント]
                    |
                    +-- TreeDelegateDrawTreeItem() --> "{ID}: {resolver} {filter}"
                    |
                    +-- TreeDelegateGenerateChildren()
                            |
                            +-- BreakpointLocationTreeDelegate [各ロケーション]
                                    |
                                    +-- TreeDelegateDrawTreeItem() --> "{bp_id}.{loc_id}: {addr}"
                                    |
                                    +-- TreeDelegateGenerateChildren()
                                            |
                                            +-- ComputeDetailsList()
                                            |
                                            +-- TextTreeDelegate [詳細テキスト]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Target -----------------------> BreakpointsTreeDelegate ----------> ツリー表示
    |                                   |
    +-- GetBreakpointList()             |
            |                           |
            +-- BreakpointList          |
                    |                   v
                    +----------> BreakpointTreeDelegate
                                        |
                                        +-- GetBreakpoint(index)
                                        |
                                        +-- GetNumLocations()
                                                |
                                                v
                                        BreakpointLocationTreeDelegate
                                                |
                                                +-- GetBreakpointLocation(index)
                                                |
                                                +-- CalculateSymbolContext()
                                                |
                                                +-- ComputeDetailsList()
                                                        |
                                                        v
                                                StringList (詳細情報)
                                                        |
                                                        v
                                                TextTreeDelegate
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | BreakpointsTreeDelegate（行5495-5538）、BreakpointTreeDelegate（行5449-5493）、BreakpointLocationTreeDelegate（行5308-5447）の実装 |
| Breakpoint.h | `lldb/include/lldb/Breakpoint/Breakpoint.h` | ヘッダー | BreakpointクラスのインターフェースGetNumLocations()、GetResolverDescription()等 |
| BreakpointLocation.h | `lldb/include/lldb/Breakpoint/BreakpointLocation.h` | ヘッダー | BreakpointLocationクラスのインターフェース |
| BreakpointList.h | `lldb/include/lldb/Breakpoint/BreakpointList.h` | ヘッダー | BreakpointListクラスのインターフェースGetBreakpointAtIndex()等 |
| SymbolContext.h | `lldb/include/lldb/Symbol/SymbolContext.h` | ヘッダー | シンボルコンテキスト情報の取得 |
| Address.h | `lldb/include/lldb/Core/Address.h` | ヘッダー | アドレス表示用Dump()メソッド |
