# 画面設計書 2-メニューバー

## 概要

本ドキュメントは、LLDB Curses GUIにおけるメニューバーの画面設計を記載する。メニューバーは、アプリケーションの主要機能（LLDB、Target、Process、Thread、View、Help）へのアクセスを提供する水平メニューである。

### 本画面の処理概要

メニューバーは、LLDBデバッガのCurses GUIの最上部に配置される1行の水平メニューであり、デバッグ操作に必要な各種機能へのアクセスポイントを提供する。

**業務上の目的・背景**：デバッグ作業における各種操作（ターゲット作成、プロセス制御、スレッド操作、表示切り替え）を、キーボードショートカット（F1〜F6）または矢印キーによるナビゲーションで効率的にアクセスできるようにする。GUIアプリケーションで一般的なメニューバー形式を採用することで、ユーザーが直感的に操作できる。

**画面へのアクセス方法**：メインウィンドウの最上部に常時表示される。F1〜F6キーを押すことで対応するメニューが開く。または、メニューバーがアクティブな状態で左右矢印キーでメニュー間を移動できる。

**主要な操作・処理内容**：
1. F1キーでLLDBメニュー（About、Exit）を開く
2. F2キーでTargetメニュー（Create、Delete）を開く
3. F3キーでProcessメニュー（Attach、Detach、Launch、Continue、Halt、Kill）を開く
4. F4キーでThreadメニュー（Step In、Step Over、Step Out）を開く
5. F5キーでViewメニュー（Backtrace、Registers、Source、Variables、Breakpoints）を開く
6. F6キーでHelpメニュー（GUI Help）を開く
7. 開いたメニュー内で上下矢印キーで項目を選択しEnterで実行

**画面遷移**：
- この画面からの遷移先：各メニュー項目選択時に対応するダイアログ・フォームへ遷移（ターゲット作成フォーム、プロセスアタッチフォーム等）
- この画面への遷移元：メインウィンドウからF1〜F6キー押下時

**権限による表示制御**：権限による表示制御は存在しない。ただし、プロセスの状態によって一部のメニュー項目が無効化される（例：プロセスが実行中の場合、Launchは選択不可）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | F1-F6キーによるメニュー選択。LLDB/Target/Process/Thread/View/Helpメニューの表示と操作 |

## 画面種別

メニューバー（ナビゲーション）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| キーボード入力 | 入力 | int | F1〜F6、矢印キー、Enter、ESC |
| メニュー選択状態 | 出力 | int | 現在選択されているメニュー/サブメニューのインデックス |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| LLDB | 左端 | F1キーに対応。About、Exitサブメニュー |
| Target | LLDBの右 | F2キーに対応。Create、Deleteサブメニュー |
| Process | Targetの右 | F3キーに対応。Attach、Detach、Launch等サブメニュー |
| Thread | Processの右 | F4キーに対応。Step In、Step Over、Step Outサブメニュー |
| View | Threadの右 | F5キーに対応。Backtrace、Registers等サブメニュー |
| Help | 右端 | F6キーに対応。GUI Helpサブメニュー |

## メニュー構造

### LLDBメニュー（F1）

| 項目名 | キー | 説明 |
|--------|------|------|
| About | - | LLDBのバージョン情報表示 |
| Exit | - | アプリケーション終了 |

### Targetメニュー（F2）

| 項目名 | キー | 説明 |
|--------|------|------|
| Create | - | 新規ターゲット作成フォームを表示 |
| Delete | - | 選択中のターゲットを削除 |

### Processメニュー（F3）

| 項目名 | キー | 説明 |
|--------|------|------|
| Attach | - | プロセスアタッチフォームを表示 |
| Detach (resume) | - | プロセスをデタッチして実行再開 |
| Detach (suspended) | - | プロセスをデタッチして停止維持 |
| Launch | - | プロセス起動フォームを表示 |
| Continue | c | 停止中のプロセスを続行 |
| Halt | - | 実行中のプロセスを停止 |
| Kill | - | プロセスを終了 |

### Threadメニュー（F4）

| 項目名 | キー | 説明 |
|--------|------|------|
| Step In | s | ソース行単位でステップイン |
| Step Over | n | ソース行単位でステップオーバー |
| Step Out | f | 現在の関数からステップアウト |

### Viewメニュー（F5）

| 項目名 | キー | 説明 |
|--------|------|------|
| Backtrace | - | バックトレース表示の切り替え |
| Registers | - | レジスタビューの表示/非表示 |
| Source | - | ソースビューの表示 |
| Variables | - | 変数ビューの表示 |
| Breakpoints | - | ブレークポイントビューの表示/非表示 |

### Helpメニュー（F6）

| 項目名 | キー | 説明 |
|--------|------|------|
| GUI Help | - | ヘルプダイアログを表示 |

## イベント仕様

### 1-F1〜F6キー押下

対応するメニューを開く。

- 処理：`Menu::WindowDelegateHandleChar()` でキー値を判定し、該当メニューを選択状態にする
- メニューが開いた状態でサブメニューが表示される

### 2-上下矢印キー押下（メニュー展開時）

サブメニュー内の選択項目を変更する。

- KEY_UP：前の項目を選択（`m_selected` をデクリメント）
- KEY_DOWN：次の項目を選択（`m_selected` をインクリメント）

### 3-左右矢印キー押下（メニュー展開時）

隣接するメニューに移動する。

- KEY_LEFT：左のメニューを開く
- KEY_RIGHT：右のメニューを開く

### 4-Enterキー押下

選択中のメニュー項目を実行する。

- 処理：`Menu::Action()` を呼び出し、`MenuDelegate::MenuDelegateAction()` に処理を委譲
- `ApplicationDelegate::MenuDelegateAction()` で各メニューIDに応じた処理を実行

### 5-ESCキー押下

メニューを閉じる。

- 処理：メニューウィンドウを削除し、メインウィンドウにフォーカスを戻す

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | - | メニューバー自体にはメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| プロセス未作成時のProcess操作 | 対象メニュー項目が無効化（グレーアウト相当） |
| ターゲット未作成時のTarget Delete | 操作が無視される |

## 備考

- Menuクラスは `WindowDelegate` を継承している
- メニューの種類は `Menu::Type` 列挙型で定義：Invalid、Bar、Item、Separator
- サブメニューは `m_submenus` ベクタで管理
- メニュー項目のショートカットキー文字は下線付きで強調表示される（`A_UNDERLINE | A_BOLD`）
- 選択中の項目は反転表示される（`A_REVERSE`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Menuクラスの構造とメニュー種別を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3876-3970行：Menuクラスの定義。メンバ変数とメソッド |
| 1-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3878行：Menu::Type列挙型（Invalid、Bar、Item、Separator） |
| 1-3 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3869-3874行：MenuDelegateインターフェース |

**読解のコツ**: Menuクラスは再帰的構造を持つ。m_submenusにサブメニューを保持し、m_parentで親メニューを参照。

#### Step 2: コンストラクタを理解する

メニューバーとメニューアイテムの生成方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3972-3978行：メニューバー/セパレータ用コンストラクタ |
| 2-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3980-3996行：メニューアイテム用コンストラクタ |

**主要処理フロー**:
1. **3988-3990行**: 名前があればType::Itemに設定
2. **3991-3992行**: キー名があればm_key_nameに設定
3. **3994行**: 名前がなければType::Separator（区切り線）

#### Step 3: 描画処理を理解する

メニューの描画ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 4023-4075行：DrawMenuTitle。メニュー項目タイトルの描画 |

**主要処理フロー**:
- **4024-4033行**: セパレータの場合は横線を描画
- **4037-4066行**: 通常項目は名前を描画、ショートカットキー文字に下線
- **4068-4075行**: キー名の表示

#### Step 4: メニューIDとアクション処理を理解する

ApplicationDelegateでのメニューアクション処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6314-6346行：メニューID列挙型（eMenuID_XXX） |
| 4-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6405-6511行：MenuDelegateAction実装 |

**主要処理フロー**:
- **6407-6418行**: eMenuID_TargetCreate → TargetCreateFormDelegate生成
- **6459-6470行**: eMenuID_ProcessAttach → ProcessAttachFormDelegate生成
- **6471-6482行**: eMenuID_ProcessLaunch → ProcessLaunchFormDelegate生成

### プログラム呼び出し階層図

```
Menu::WindowDelegateHandleChar() [キー入力受信]
    │
    ├─ [F1-F6キー] → メニューを開く
    │      └─ Menu::DrawAndRunMenu()
    │             └─ Menu::WindowDelegateDraw() [サブメニュー描画]
    │
    ├─ [上下矢印] → m_selected を変更
    │
    ├─ [左右矢印] → 隣接メニューに移動
    │
    └─ [Enter] → Menu::Action()
           └─ Menu::ActionPrivate()
                  └─ MenuDelegate::MenuDelegateAction()
                         │
                         ├─ ApplicationDelegate::MenuDelegateAction()
                         │      ├─ TargetCreateFormDelegate [Create Target]
                         │      ├─ ProcessAttachFormDelegate [Attach Process]
                         │      ├─ ProcessLaunchFormDelegate [Launch Process]
                         │      └─ Process::Resume() / Destroy() 等
                         │
                         └─ MenuActionResult を返却
```

### データフロー図

```
[入力]                    [処理]                        [出力]

F1-F6キー ───────────▶ Menu::WindowDelegateHandleChar() ─▶ サブメニュー表示
                                │
上下矢印キー ─────────▶ m_selected 更新              ─▶ 選択項目変更
                                │
Enterキー ────────────▶ Menu::Action()               ─▶ アクション実行
                        │                                │
                        └─▶ MenuDelegateAction()         ├─▶ フォームダイアログ表示
                                                         └─▶ プロセス制御
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | Menuクラス、MenuDelegateインターフェース、ApplicationDelegateの実装 |
| IOHandlerCursesGUI.h | `lldb/include/lldb/Core/IOHandlerCursesGUI.h` | ヘッダ | IOHandlerCursesGUIクラスの宣言 |
