# 画面設計書 3-ソースビュー

## 概要

本ドキュメントは、LLDB Curses GUIにおけるソースビューの画面設計を記載する。ソースビューは、デバッグ対象プログラムのソースコードまたはディスアセンブリを表示し、ブレークポイントの設定やステップ実行などのデバッグ操作を行うための中心的なウィンドウである。

### 本画面の処理概要

ソースビューは、LLDBデバッガのCurses GUIにおいてプログラムの実行状態を視覚的に確認し、デバッグ操作を行うための主要ウィンドウである。

**業務上の目的・背景**：デバッグ作業において、現在実行中のコードの位置を視覚的に確認することは極めて重要である。ソースビューは、ソースコードまたはディスアセンブリを表示し、現在のプログラムカウンタ（PC）位置をダイヤモンド記号で強調表示する。また、ブレークポイントの設定状況を色で示し、直感的なデバッグ操作を可能にする。

**画面へのアクセス方法**：メインウィンドウの左側に常時表示される。TABキーでフォーカスを切り替えることでアクティブ化できる。

**主要な操作・処理内容**：
1. 上下矢印キーでソース行の選択を変更
2. 左右矢印キーで水平スクロール
3. Page Up/Downまたは`,`/`.`キーでページ単位スクロール
4. `b`キーで選択行にブレークポイントを設定/解除
5. `c`キーでプロセスを続行（continue）
6. `n`/`N`キーでステップオーバー（ソース行/命令単位）
7. `s`/`S`キーでステップイン（ソース行/命令単位）
8. `f`キーでステップアウト（finish）
9. `u`/`d`キーでフレームアップ/ダウン
10. Enter キーで選択行までワンショットブレークポイントで実行

**画面遷移**：
- この画面からの遷移先：ヘルプダイアログ（hキー）
- この画面への遷移元：メインウィンドウ内のサブウィンドウとして常時表示

**権限による表示制御**：権限による表示制御は存在しない。ただし、プロセスの状態によって一部の操作が制限される（例：停止中でないとステップ実行不可）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | SourceFileWindowDelegateによるソースコード表示。現在実行中のファイルと行番号のハイライト表示 |
| 8 | LLDB | 補助機能 | bキーによるブレークポイント設定。選択行へのブレークポイント追加/削除 |
| 8 | LLDB | 補助機能 | n/N/s/S/fキーによるステップ実行。ステップイン/ステップオーバー/ステップアウト操作 |
| 8 | LLDB | 補助機能 | cキーによるプロセス続行。停止中のプロセスの実行再開 |

## 画面種別

詳細表示（ソースコード/ディスアセンブリビューア）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| キーボード入力 | 入力 | int | 矢印キー、b、c、n、s、f、u、d、h、Enter等 |
| ソースファイル | 入力 | SourceFile | デバッグ対象のソースファイル |
| ディスアセンブリ | 入力 | InstructionList | ソースがない場合の逆アセンブリ |
| ExecutionContext | 入力 | ExecutionContext | 現在の実行コンテキスト（Process、Thread、Frame） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトルバー | ウィンドウ上部（1行目） | "Sources" というタイトル |
| モジュール/関数名 | ウィンドウ上部（2行目） | 現在のモジュール名と関数名（反転表示） |
| 行番号 | 各行左端 | ソース行番号（右寄せ、桁数は動的） |
| ブレークポイント表示 | 行番号の背景色 | ブレークポイント設定行は BlackOnWhite で強調 |
| PCマーカー | 行番号右の縦線の右 | 現在のPC行にダイヤモンド記号（ACS_DIAMOND） |
| ソースコード | 各行メイン領域 | ソースコードテキスト（シンタックスハイライト対応） |
| 選択行表示 | 選択行全体 | 反転表示（A_REVERSE） |
| 停止理由 | PC行右端 | "<<< Thread N: 停止理由" （WhiteOnBlue背景） |

## イベント仕様

### 1-上下矢印キー押下

ソース行の選択を変更する。

- KEY_UP：m_selected_line をデクリメント（7291-7296行）
- KEY_DOWN：m_selected_line をインクリメント（7298-7304行）
- 表示範囲外になった場合は m_first_visible_line を調整してスクロール

### 2-左右矢印キー押下

水平スクロールを行う。

- KEY_LEFT：m_first_visible_column をデクリメント（7306-7309行）
- KEY_RIGHT：m_first_visible_column をインクリメント（7311-7313行）

### 3-Page Up/Down（`,`/`.`またはPage Up/Page Down）

ページ単位でスクロールする。

- Page Up（`,`）：num_visible_lines 分だけ上にスクロール（7266-7274行）
- Page Down（`.`）：num_visible_lines 分だけ下にスクロール（7276-7288行）

### 4-`b`キー押下

選択行にブレークポイントを設定/解除する。

- 処理：`ToggleBreakpointOnSelectedLine()` を呼び出し（7358-7360行）
- 既存のブレークポイントがあれば削除、なければ新規作成
- ソースブレークポイントまたはアドレスブレークポイント（ディスアセンブリ時）

### 5-`c`キー押下

プロセスを続行する。

- 処理：`exe_ctx.GetProcessRef().Resume()` を呼び出し（7371-7379行）
- プロセスが存在し、停止中の場合のみ有効

### 6-`n`/`N`キー押下

ステップオーバーを実行する。

- `n`：ソース行単位でステップオーバー（source_step = true）
- `N`：命令単位でステップオーバー（source_step = false）
- 処理：`exe_ctx.GetThreadRef().StepOver(source_step)` を呼び出し（7396-7407行）

### 7-`s`/`S`キー押下

ステップインを実行する。

- `s`：ソース行単位でステップイン（source_step = true）
- `S`：命令単位でステップイン（source_step = false）
- 処理：`exe_ctx.GetThreadRef().StepIn(source_step)` を呼び出し（7409-7420行）

### 8-`f`キー押下

ステップアウト（finish）を実行する。

- 処理：`exe_ctx.GetThreadRef().StepOut(frame_idx)` を呼び出し（7381-7394行）
- 現在の関数から抜けて呼び出し元に戻る

### 9-`u`/`d`キー押下

スタックフレームを上下に移動する。

- `u`：フレームアップ（呼び出し元へ）
- `d`：フレームダウン（呼び出し先へ）
- 処理：`thread->SetSelectedFrameByIndex()` を呼び出し（7422-7441行）

### 10-Enterキー押下

選択行までワンショットブレークポイントで実行する。

- 処理：選択行にワンショットブレークポイントを設定後、`Resume()` を呼び出し（7315-7356行）
- ブレークポイントは1回ヒット後に自動削除される

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | "Source/Disassembly window keyboard shortcuts:" | ヘルプダイアログ表示時 |
| MSG-002 | 情報 | "<<< Thread N: 停止理由" | プロセスが停止した場合、PC行に表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ソースファイルが見つからない | ディスアセンブリ表示に自動切り替え |
| プロセスが実行中 | ステップ操作等が無効化（キー入力を無視） |
| ターゲット未設定 | ブレークポイント設定等が無効化 |

## 備考

- SourceFileWindowDelegateクラスで実装されている
- ソースファイルがない場合は自動的にディスアセンブリ表示に切り替わる
- PC行はダイヤモンド記号（ACS_DIAMOND）でマーク
- ブレークポイント行は反転表示（BlackOnWhite）
- 選択行とPC行が異なる場合、選択行は反転表示（A_REVERSE）
- 停止理由は WhiteOnBlue 背景で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ソースビューの状態管理に使用されるメンバ変数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6785-6824行：SourceFileWindowDelegateクラス定義、キーヘルプ配列 |

**読解のコツ**: m_selected_line、m_first_visible_line、m_pc_line などの変数がビューの状態を管理。m_file_sp と m_disassembly_sp でソース/ディスアセンブリを切り替え。

#### Step 2: 描画処理を理解する

WindowDelegateDraw メソッドの描画ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6826-6965行：描画メソッドの前半（状態更新、ファイル/ディスアセンブリ切り替え） |
| 2-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6967-7084行：描画メソッドの後半（ソースコード表示、ブレークポイント表示） |

**主要処理フロー**:
1. **6826-6839行**: ExecutionContextからProcess/Thread状態を取得
2. **6850-6965行**: ソースファイルまたはディスアセンブリの選択と行番号更新
3. **6967-6980行**: タイトルバーとモジュール名の描画
4. **6984-7006行**: ブレークポイント位置の収集
5. **7008-7084行**: 各ソース行の描画（行番号、PCマーカー、ソースコード、停止理由）

#### Step 3: キー入力処理を理解する

WindowDelegateHandleChar メソッドのキー処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 7261-7451行：キー入力ハンドラ全体 |

**主要処理フロー**:
- **7266-7288行**: ページスクロール（`,`/`.`、Page Up/Down）
- **7290-7313行**: 行選択と水平スクロール（矢印キー）
- **7315-7356行**: ワンショットブレークポイント実行（Enter）
- **7358-7360行**: ブレークポイントトグル（b）
- **7371-7379行**: プロセス続行（c）
- **7381-7420行**: ステップ操作（n、N、s、S、f）
- **7422-7441行**: フレーム移動（u、d）

#### Step 4: ブレークポイント操作を理解する

ToggleBreakpointOnSelectedLine メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 7453-7500行：ブレークポイントトグル処理 |

**主要処理フロー**:
- **7460-7482行**: 既存ブレークポイントの検索と削除
- **7483-7495行**: 新規ブレークポイントの作成

### プログラム呼び出し階層図

```
SourceFileWindowDelegate::WindowDelegateDraw() [描画]
    │
    ├─ Debugger::GetCommandInterpreter().GetExecutionContext()
    │      └─ Process/Thread/Frame 状態取得
    │
    ├─ SourceManager::GetFile() [ソースファイル取得]
    │
    ├─ Function/Symbol::GetInstructions() [ディスアセンブリ取得]
    │
    └─ Window描画メソッド群
           ├─ DrawTitleBox()
           ├─ OutputColoredStringTruncated()
           └─ Printf() / PutChar()

SourceFileWindowDelegate::WindowDelegateHandleChar() [キー入力]
    │
    ├─ [b] → ToggleBreakpointOnSelectedLine()
    │         ├─ BreakpointList::GetBreakpointAtIndex()
    │         ├─ Target::RemoveBreakpointByID()
    │         └─ Target::CreateBreakpoint()
    │
    ├─ [c] → Process::Resume()
    │
    ├─ [n/N] → Thread::StepOver()
    │
    ├─ [s/S] → Thread::StepIn()
    │
    ├─ [f] → Thread::StepOut()
    │
    ├─ [u/d] → Thread::SetSelectedFrameByIndex()
    │
    └─ [Enter] → Target::CreateBreakpoint() [OneShot]
                  └─ Process::Resume()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

ExecutionContext ──────────▶ SourceFileWindowDelegate      ─▶ ソースコード表示
(Process/Thread/Frame)       ::WindowDelegateDraw()           ディスアセンブリ表示

SourceFile ────────────────▶ DisplaySourceLines()          ─▶ 行テキスト
                             OutputColoredStringTruncated()

BreakpointList ────────────▶ GetBreakpointAtIndex()        ─▶ ブレークポイント強調表示

キーボード入力 ────────────▶ WindowDelegateHandleChar()    ┌─▶ m_selected_line 更新
(b/c/n/s/f/u/d/Enter)                                       ├─▶ ブレークポイント操作
                                                            └─▶ ステップ実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | SourceFileWindowDelegateクラスの実装 |
| SourceManager.h | `lldb/include/lldb/Core/SourceManager.h` | ヘッダ | ソースファイル管理クラス |
| Disassembler.h | `lldb/include/lldb/Core/Disassembler.h` | ヘッダ | ディスアセンブラクラス |
| Breakpoint.h | `lldb/include/lldb/Breakpoint/Breakpoint.h` | ヘッダ | ブレークポイントクラス |
| Thread.h | `lldb/include/lldb/Target/Thread.h` | ヘッダ | スレッドクラス（ステップ操作） |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダ | プロセスクラス（Resume等） |
