# 画面設計書 5-スレッドビュー

## 概要

本ドキュメントは、LLDB Curses GUIにおけるスレッドビューの画面設計を記載する。スレッドビューは、プロセス内の全スレッドの一覧を表示し、各スレッドのスタックフレームを確認できるツリー形式のウィンドウである。

### 本画面の処理概要

スレッドビューは、デバッグ中のプロセス内に存在する全てのスレッドを一覧表示し、各スレッドの状態とスタックフレームを確認するためのウィンドウである。

**業務上の目的・背景**：マルチスレッドアプリケーションのデバッグにおいて、各スレッドの状態を把握することは重要である。スレッドビューは、プロセス内の全スレッドをツリー形式で表示し、選択したスレッドのスタックフレームを展開して確認できる。デッドロックや競合状態の解析、各スレッドの実行位置の確認に活用される。

**画面へのアクセス方法**：メインウィンドウの右側に常時表示される。TABキーでフォーカスを切り替えることでアクティブ化できる。

**主要な操作・処理内容**：
1. 上下矢印キーでスレッド/フレームの選択を変更
2. 右矢印キーでスレッドを展開しスタックフレームを表示
3. 左矢印キーでスレッドを折りたたみ、または親を選択
4. Enterキーで選択したスレッド/フレームをアクティブに設定
5. Page Up/Downでページ単位スクロール

**画面遷移**：
- この画面からの遷移先：ヘルプダイアログ（hキー）
- この画面への遷移元：メインウィンドウ内のサブウィンドウとして常時表示

**権限による表示制御**：権限による表示制御は存在しない。プロセスが実行中の場合、描画をスキップする。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | ThreadsTreeDelegateによるスレッド一覧表示。プロセス内の全スレッドとスタックフレームの表示 |
| 8 | LLDB | 補助機能 | スレッド選択によるコンテキスト切り替え。選択したスレッドのスタックフレーム表示 |

## 画面種別

一覧表示（ツリービュー）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| キーボード入力 | 入力 | int | 矢印キー、Enter、Page Up/Down |
| ExecutionContext | 入力 | ExecutionContext | 現在の実行コンテキスト |
| Process | 入力 | Process | デバッグ対象プロセス |
| ThreadList | 入力 | ThreadList | プロセス内のスレッド一覧 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| プロセス情報 | ルート行 | "process {PID}{, name = {プロセス名}}" 形式 |
| スレッド情報 | 子行 | スレッドID、名前、状態、停止理由等 |
| スタックフレーム | 孫行 | フレーム番号、関数名、ソース位置 |
| 選択行表示 | 選択行全体 | ハイライト表示 |

## イベント仕様

### 1-上下矢印キー押下

スレッド/フレームの選択を変更する。

- KEY_UP：前の項目を選択
- KEY_DOWN：次の項目を選択
- 展開されている場合は子要素も選択対象

### 2-左右矢印キー押下

スレッドの展開/折りたたみを行う。

- KEY_RIGHT：選択したスレッドを展開（スタックフレームを表示）
- KEY_LEFT：展開中の場合は折りたたみ、折りたたみ済みの場合は親を選択

### 3-Enterキー押下

選択したスレッド/フレームをアクティブに設定する。

- スレッドを選択した場合：そのスレッドをカレントスレッドに設定
- フレームを選択した場合：そのスレッドをカレントスレッドに設定し、そのフレームを選択

### 4-Page Up/Downキー押下

ページ単位でスクロールする。

### 5-hキー押下

ヘルプダイアログを表示する。

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | "process {PID}{, name = {name}}" | プロセス情報行 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| プロセスが存在しない | 何も表示しない |
| プロセスが実行中 | 描画をスキップ（前の状態を維持） |
| スレッドが終了した | 次回更新時にリストから削除 |

## 備考

- ThreadsTreeDelegateクラスで実装
- TreeDelegateを継承してツリー表示機能を利用
- プロセスのstop_idが変わった場合のみスレッドリストを更新
- フォーマットエンティティ "process ${process.id}{, name = ${process.name}}" を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ThreadsTreeDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 5190-5240行：ThreadsTreeDelegateクラス定義、フォーマット文字列 |

**読解のコツ**: FormatEntityを使用してプロセス情報をフォーマット。TreeDelegateを継承してツリー表示を実現。

#### Step 2: 描画処理を理解する

ツリーアイテムの描画と子要素の生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 5206-5228行：TreeDelegateShouldDraw、TreeDelegateDrawTreeItem |
| 2-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 5230-5240行：TreeDelegateGenerateChildren |

**主要処理フロー**:
1. **5206-5214行**: TreeDelegateShouldDraw でプロセス状態をチェック
2. **5217-5228行**: TreeDelegateDrawTreeItem でプロセス情報を描画
3. **5230行以降**: TreeDelegateGenerateChildren でスレッドリストを子要素として生成

### プログラム呼び出し階層図

```
ThreadsTreeDelegate
    │
    ├─ TreeDelegateShouldDraw()
    │      └─ Process::GetState() で実行状態チェック
    │
    ├─ TreeDelegateDrawTreeItem()
    │      └─ FormatEntity::Formatter で "process {PID}" 形式で描画
    │
    └─ TreeDelegateGenerateChildren()
           └─ Process::GetThreadList() からスレッドを取得
                  └─ ThreadTreeDelegate（子デリゲート）を生成
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Process ───────────────────▶ ThreadsTreeDelegate            ─▶ プロセス情報行
                             ::TreeDelegateDrawTreeItem()

ThreadList ─────────────────▶ TreeDelegateGenerateChildren() ─▶ スレッド行リスト

Thread ─────────────────────▶ ThreadTreeDelegate             ─▶ スタックフレーム行
                             ::TreeDelegateGenerateChildren()

キーボード入力 ────────────▶ TreeWindowDelegate              ┌─▶ 選択変更
(矢印/Enter)                 ::WindowDelegateHandleChar()    └─▶ スレッド/フレーム選択
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | ThreadsTreeDelegateの実装 |
| Thread.h | `lldb/include/lldb/Target/Thread.h` | ヘッダ | スレッドクラス |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダ | プロセスクラス |
| FormatEntity.h | `lldb/include/lldb/Core/FormatEntity.h` | ヘッダ | フォーマットエンティティ |
