# 画面設計書 6-ステータスバー

## 概要

本ドキュメントは、LLDB Curses GUIにおけるステータスバーの画面設計を記載する。ステータスバーは、メインウィンドウの最下部に配置され、プロセスID、プロセス状態、現在のスレッドID、フレーム情報を常時表示する情報バーである。

### 本画面の処理概要

ステータスバーは、デバッグセッションの現在の状態を一行で要約表示する情報ウィンドウである。

**業務上の目的・背景**：デバッグ作業中、プロセスとスレッドの状態を常に把握しておくことは重要である。ステータスバーは、現在のデバッグコンテキスト（プロセスID、状態、スレッドID、プログラムカウンタ）を一目で確認できるようにし、デバッグ作業の効率を向上させる。

**画面へのアクセス方法**：メインウィンドウの最下部に常時表示される。フォーカスを受け取ることはない（情報表示専用）。

**主要な操作・処理内容**：
1. プロセスID（PID）の表示
2. プロセス状態（stopped、running、exited等）の表示
3. 現在のスレッドIDの表示
4. 現在のフレーム番号とプログラムカウンタ（PC）の表示
5. プロセス終了時は終了ステータスと説明を表示

**画面遷移**：
- この画面からの遷移先：なし（情報表示専用）
- この画面への遷移元：メインウィンドウ内のサブウィンドウとして常時表示

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | StatusBarWindowDelegateによるプロセス状態表示。PID/状態/スレッドID/フレーム情報の表示 |

## 画面種別

情報表示バー

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| ExecutionContext | 入力 | ExecutionContext | 現在の実行コンテキスト |
| Process | 入力 | Process | プロセス情報 |
| Thread | 入力 | Thread | スレッド情報 |
| StackFrame | 入力 | StackFrame | フレーム情報 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| プロセス情報 | 左端 | "Process: {PID} {状態}" 形式 |
| スレッド情報 | 中央（40カラム目） | "Thread: {スレッドID}" 形式 |
| フレーム情報 | 右側（60カラム目） | "Frame: {番号}  PC = 0x{アドレス}" 形式 |
| 終了情報 | プロセス終了時 | "with status = {ステータス} ({説明})" 形式 |

## イベント仕様

ステータスバーは情報表示専用であり、ユーザー操作イベントは受け付けない。描画のみを行う。

### 1-プロセス状態変更時

自動的にステータスバーの表示が更新される。

- 処理：WindowDelegateDraw が呼び出され、最新の状態を表示
- 表示内容：プロセスID、状態（stopped/running/exited等）

### 2-スレッド/フレーム変更時

選択されたスレッドとフレームの情報が更新される。

- 処理：ExecutionContext から Thread と Frame を取得
- 表示内容：スレッドID、フレーム番号、PC

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | "Process: {PID} {state}" | プロセス存在時 |
| MSG-002 | 情報 | "Thread: {TID}" | スレッド選択時 |
| MSG-003 | 情報 | "Frame: {N}  PC = 0x{addr}" | フレーム選択時 |
| MSG-004 | 情報 | "with status = {status} ({desc})" | プロセス終了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| プロセスが存在しない | 空のステータスバーを表示 |
| スレッドが選択されていない | スレッド情報を省略 |
| フレームがない | フレーム情報を省略 |

## 備考

- StatusBarWindowDelegateクラスで実装
- 背景色は BlackOnWhite（黒文字に白背景）
- フォーマットエンティティ "Thread: ${thread.id%tid}" を使用
- 1行のみの表示領域

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

StatusBarWindowDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6731-6782行：StatusBarWindowDelegateクラス定義 |

**読解のコツ**: FormatEntityを使用してスレッドIDをフォーマット。WindowDelegateを継承。

#### Step 2: 描画処理を理解する

WindowDelegateDraw メソッドの描画ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6739-6777行：WindowDelegateDraw実装 |

**主要処理フロー**:
1. **6739-6744行**: ExecutionContextから Process/Thread/Frame を取得
2. **6745-6747行**: ウィンドウをクリアし、BlackOnWhite背景を設定
3. **6748-6751行**: プロセスID と状態を表示
4. **6753-6760行**: 停止状態の場合、スレッドIDを表示
5. **6762-6767行**: フレーム番号とPCを表示
6. **6768-6774行**: 終了状態の場合、終了ステータスを表示

### プログラム呼び出し階層図

```
StatusBarWindowDelegate::WindowDelegateDraw() [描画]
    │
    ├─ Debugger::GetCommandInterpreter().GetExecutionContext()
    │      └─ Process/Thread/Frame 状態取得
    │
    ├─ Window::Erase() [クリア]
    │
    ├─ Window::SetBackground(BlackOnWhite) [背景設定]
    │
    ├─ Process::GetID() [PID取得]
    │
    ├─ Process::GetState() [状態取得]
    │      └─ StateAsCString() で文字列化
    │
    ├─ FormatEntity::Formatter() [スレッドID整形]
    │
    ├─ Frame::GetFrameIndex() [フレーム番号]
    │
    └─ Frame::GetFrameCodeAddress() [PC取得]
```

### データフロー図

```
[入力]                       [処理]                           [出力]

ExecutionContext ──────────▶ StatusBarWindowDelegate        ─▶ ステータス表示
                             ::WindowDelegateDraw()

Process::GetID() ───────────▶ Printf("Process: %5" PRIu64)  ─▶ "Process: {PID}"

Process::GetState() ────────▶ StateAsCString()              ─▶ "{状態}"

Thread::GetID() ────────────▶ FormatEntity::Formatter       ─▶ "Thread: {TID}"

Frame::GetFrameIndex() ─────▶ Printf("Frame: %3u")          ─▶ "Frame: {N}"

Frame::GetFrameCodeAddress() ▶ GetOpcodeLoadAddress()       ─▶ "PC = 0x{addr}"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | StatusBarWindowDelegateの実装 |
| State.h | `lldb/include/lldb/Utility/State.h` | ヘッダ | StateAsCString関数 |
| FormatEntity.h | `lldb/include/lldb/Core/FormatEntity.h` | ヘッダ | フォーマットエンティティ |
