# 画面設計書 7-ヘルプダイアログ

## 概要

本ドキュメントは、LLDB Curses GUIにおけるヘルプダイアログの画面設計を記載する。ヘルプダイアログは、キーボードショートカットの一覧を表示するモーダルダイアログウィンドウである。

### 本画面の処理概要

ヘルプダイアログは、現在アクティブなウィンドウで使用可能なキーボードショートカットの説明を一覧表示するダイアログウィンドウである。

**業務上の目的・背景**：CUIベースのアプリケーションでは、利用可能なキーボードショートカットを覚えることが重要である。ヘルプダイアログは、hキーを押すことでいつでも呼び出せるヘルプ機能を提供し、ユーザーが操作方法を忘れた場合にすぐ確認できるようにする。

**画面へのアクセス方法**：任意のウィンドウがアクティブな状態で `h` キーを押すことで表示される。

**主要な操作・処理内容**：
1. ヘルプテキストとキーボードショートカット一覧の表示
2. 上下矢印キーでスクロール（内容が多い場合）
3. Page Up/Down（`,`/`.`）でページスクロール
4. 任意のキー押下でダイアログを閉じる（スクロール不要な場合）
5. ESCキーまたは矢印キー以外のキーでダイアログを閉じる（スクロール可能な場合）

**画面遷移**：
- この画面からの遷移先：元のウィンドウ（任意のキーまたはESCで閉じる）
- この画面への遷移元：メインウィンドウまたは各サブウィンドウからhキー押下時

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | HelpDialogDelegateによるキーボードショートカット一覧表示。hキーで表示されるヘルプテキスト |

## 画面種別

ダイアログ（モーダル）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| キーボード入力 | 入力 | int | 矢印キー（スクロール）、その他キー（閉じる） |
| ヘルプテキスト | 入力 | const char* | ウィンドウ固有のヘルプテキスト |
| キーヘルプ配列 | 入力 | KeyHelp* | ショートカットキーと説明の配列 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトル | ダイアログ上部 | ウィンドウ名（"Help"等） |
| ヘルプテキスト | ダイアログ上部 | ウィンドウ固有の説明文 |
| キーショートカット一覧 | ダイアログ中央 | "{キー名} - {説明}" 形式の一覧 |
| フッターメッセージ | ダイアログ下部 | "Press any key to exit" または "Use arrows to scroll, any other key to exit" |

## イベント仕様

### 1-上下矢印キー押下

ヘルプテキストをスクロールする（内容が表示領域を超える場合のみ）。

- KEY_UP：m_first_visible_line をデクリメント（6273-6276行）
- KEY_DOWN：m_first_visible_line をインクリメント（6278-6281行）

### 2-Page Up/Downキー押下

ページ単位でスクロールする。

- KEY_PPAGE または `,`：num_visible_lines 分だけ上にスクロール（6283-6291行）
- KEY_NPAGE または `.`：num_visible_lines 分だけ下にスクロール（6293-6300行）

### 3-その他のキー押下

ダイアログを閉じる。

- 処理：親ウィンドウから削除
- スクロールが不要な場合（全行が表示可能な場合）は、どのキーでも即座に閉じる

## データベース更新仕様

該当なし（データベースは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | "Press any key to exit" | スクロール不要時 |
| MSG-002 | 情報 | "Use arrows to scroll, any other key to exit" | スクロール可能時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ヘルプテキストが空 | 空のダイアログを表示 |
| キーヘルプ配列がnull | テキストのみ表示 |

## 備考

- HelpDialogDelegateクラスで実装
- WindowDelegateを継承
- ヘルプテキストはStringListに行分割して保持
- キーショートカットは "{キー名} - {説明}" 形式でフォーマット
- CursesKeyToCString関数でキーコードを文字列に変換

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HelpDialogDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 332-349行：HelpDialogDelegateクラス宣言 |
| 1-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 284-287行：KeyHelp構造体定義 |

**読解のコツ**: m_textはStringListで行単位のテキストを保持。m_first_visible_lineでスクロール位置を管理。

#### Step 2: コンストラクタを理解する

ヘルプテキストとキーヘルプの初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6218-6233行：コンストラクタ実装 |

**主要処理フロー**:
1. **6221-6224行**: ヘルプテキストを行に分割して m_text に追加
2. **6225-6231行**: KeyHelp配列をループし、各キーの説明を追加
3. **6228-6230行**: "{キー名} - {説明}" 形式でフォーマット

#### Step 3: 描画処理を理解する

WindowDelegateDraw メソッドの描画ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6237-6259行：WindowDelegateDraw実装 |

**主要処理フロー**:
- **6238行**: ウィンドウをクリア
- **6247-6250行**: スクロール可否に応じてフッターメッセージを決定
- **6251行**: タイトルボックスとフッターを描画
- **6252-6257行**: テキストを行ごとに描画

#### Step 4: キー入力処理を理解する

WindowDelegateHandleChar メソッドのキー処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 6261-6310行：WindowDelegateHandleChar実装 |

**主要処理フロー**:
- **6267-6270行**: 全行表示可能なら即座にdone=true
- **6272-6300行**: スクロール処理（矢印/Page）
- **6302行以降**: その他のキーでダイアログを閉じる

### プログラム呼び出し階層図

```
Window::CreateHelpSubwindow() [ヘルプダイアログ作成]
    │
    ├─ WindowDelegate::WindowDelegateGetHelpText() [テキスト取得]
    │
    ├─ WindowDelegate::WindowDelegateGetKeyHelp() [キーヘルプ取得]
    │
    └─ HelpDialogDelegate コンストラクタ
           ├─ StringList::SplitIntoLines() [テキスト分割]
           └─ CursesKeyToCString() [キーコード→文字列変換]

HelpDialogDelegate::WindowDelegateDraw() [描画]
    │
    ├─ Window::Erase()
    │
    ├─ Window::DrawTitleBox() [タイトルとフッター描画]
    │
    └─ Window::PutCStringTruncated() [テキスト描画]

HelpDialogDelegate::WindowDelegateHandleChar() [キー入力]
    │
    ├─ [矢印/Page] → m_first_visible_line 更新
    │
    └─ [その他] → ダイアログ削除
```

### データフロー図

```
[入力]                       [処理]                           [出力]

WindowDelegate::         ───▶ HelpDialogDelegate           ─▶ ヘルプテキスト表示
GetHelpText()                 コンストラクタ
GetKeyHelp()

キーボード入力 ────────────▶ WindowDelegateHandleChar()    ┌─▶ スクロール
(矢印/Page/その他)                                          └─▶ ダイアログ閉じる
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | HelpDialogDelegateの実装 |
| StringList.h | `lldb/include/lldb/Utility/StringList.h` | ヘッダ | 文字列リストクラス |
