# 画面設計書 8-ターゲット作成フォーム

## 概要

本ドキュメントは、LLDB Curses GUIにおけるターゲット作成フォームの画面設計を記載する。ターゲット作成フォームは、デバッグ対象の実行ファイルを選択し、新しいデバッグターゲットを作成するためのフォームダイアログである。

### 本画面の処理概要

ターゲット作成フォームは、デバッグセッションの開始時に、デバッグ対象となる実行ファイルを指定し、オプションでコアファイルやシンボルファイルを設定するためのダイアログである。

**業務上の目的・背景**：デバッグ作業を開始するには、まずデバッグ対象となるターゲット（実行ファイル）を設定する必要がある。このフォームは、実行ファイルのパス、コアファイル（クラッシュダンプ解析用）、シンボルファイル（デバッグ情報）を指定できる。また、詳細設定としてリモートデバッグ用のファイル、アーキテクチャ、プラットフォーム、依存ファイルの読み込み設定も可能。

**画面へのアクセス方法**：メニューバーから F2（Target） > Create を選択することで表示される。

**主要な操作・処理内容**：
1. 実行ファイルパスの入力（必須）
2. コアファイルパスの入力（オプション）
3. シンボルファイルパスの入力（オプション）
4. 詳細設定の表示/非表示切り替え
5. リモートファイルパスの入力（詳細設定）
6. アーキテクチャの指定（詳細設定）
7. プラットフォームの選択（詳細設定）
8. 依存ファイルの読み込みオプション選択（詳細設定）
9. Createボタンでターゲット作成

**画面遷移**：
- この画面からの遷移先：メインウィンドウ（作成成功時）、同画面（エラー時）
- この画面への遷移元：メニューバー > Target > Create

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | TargetCreateFormDelegateによるデバッグターゲット設定。実行ファイル/コアファイル/シンボルファイルの選択 |
| 8 | LLDB | 遷移先機能 | Createボタンによるターゲット作成。Debugger::GetTargetListへのターゲット追加 |

## 画面種別

フォームダイアログ（モーダル）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Executable | 入力 | ファイルパス | 必須 | デバッグ対象の実行ファイルパス |
| Core File | 入力 | ファイルパス | オプション | コアダンプファイルパス |
| Symbol File | 入力 | ファイルパス | オプション | シンボルファイルパス |
| Show advanced settings | 入力 | ブール | - | 詳細設定の表示/非表示 |
| Remote File | 入力 | ファイルパス | オプション | リモートデバッグ用ファイルパス（詳細） |
| Architecture | 入力 | 文字列 | オプション | ターゲットアーキテクチャ（詳細） |
| Platform | 入力 | 選択リスト | オプション | プラットフォーム選択（詳細） |
| Load Dependents | 入力 | 選択リスト | オプション | 依存ファイル読み込み設定（詳細） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| フォームタイトル | ダイアログ上部 | "Create Target" |
| Executableフィールド | フォーム上部 | 実行ファイルパス入力（必須マーク付き） |
| Core Fileフィールド | Executableの下 | コアファイルパス入力 |
| Symbol Fileフィールド | Core Fileの下 | シンボルファイルパス入力 |
| Show advanced settingsチェックボックス | 基本設定の下 | 詳細設定トグル |
| Remote Fileフィールド | 詳細設定領域 | リモートファイルパス入力（非表示可） |
| Architectureフィールド | 詳細設定領域 | アーキテクチャ入力（非表示可） |
| Platformフィールド | 詳細設定領域 | プラットフォーム選択（非表示可） |
| Load Dependentsフィールド | 詳細設定領域 | 依存ファイル読み込み選択（非表示可） |
| Createボタン | フォーム下部 | ターゲット作成アクション |
| エラーメッセージ | フォーム下部 | バリデーションエラー表示 |

## イベント仕様

### 1-Show advanced settings チェック変更

詳細設定フィールドの表示/非表示を切り替える。

- 処理：UpdateFieldsVisibility() が呼び出される（3099-3111行）
- チェックON：Remote File、Architecture、Platform、Load Dependents フィールドを表示
- チェックOFF：詳細設定フィールドを非表示

### 2-Createボタン押下

ターゲットを作成する。

- 処理：CreateTarget(Window &window) が呼び出される（3211-3241行）
- フロー：
  1. フィールドのバリデーションチェック
  2. TargetList::CreateTarget() でターゲット作成
  3. シンボルファイルの設定（指定時）
  4. コアファイルの読み込み（指定時）
  5. リモートファイルの設定（指定時）
  6. 成功時：ダイアログを閉じる
  7. 失敗時：エラーメッセージを表示

### 3-ESCキー押下

フォームをキャンセルして閉じる。

## データベース更新仕様

該当なし（データベースは使用しない）

LLDB内部データ構造の更新：
| 操作 | 対象 | 概要 |
|-----|------|------|
| TargetList::CreateTarget | TargetList | 新規ターゲットの追加 |
| TargetList::SetSelectedTarget | TargetList | 作成したターゲットを選択状態に |
| Module::SetSymbolFileFileSpec | Module | シンボルファイルの設定 |
| Target::CreateProcess | Target | コアファイルからプロセス作成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | "Some fields are invalid!" | フィールドバリデーション失敗時 |
| MSG-002 | エラー | "{Status::AsCString()}" | ターゲット作成失敗時 |
| MSG-003 | エラー | "Unknown core file format!" | コアファイル読み込み失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 実行ファイルが存在しない | エラーメッセージを表示、ターゲット作成をキャンセル |
| コアファイル形式が不明 | エラーメッセージを表示、作成したターゲットを削除 |
| シンボルファイル読み込み失敗 | エラーメッセージを表示、作成したターゲットを削除 |

## 備考

- TargetCreateFormDelegateクラスで実装
- FormDelegateを継承してフォーム機能を利用
- 詳細設定フィールドは初期状態で非表示
- Load Dependentsの選択肢：Executable only、Yes、No
- ターゲット作成に失敗した場合、作成したターゲットを自動削除

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TargetCreateFormDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3077-3254行：TargetCreateFormDelegateクラス定義 |
| 1-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 2288-2340行：FormDelegate基底クラス |

**読解のコツ**: 各フィールドはAddXxxFieldメソッドで追加。AddActionでボタンを追加。

#### Step 2: フィールド初期化を理解する

コンストラクタでのフィールド設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3079-3094行：コンストラクタ（フィールド追加） |

**主要処理フロー**:
1. **3080-3081行**: Executableフィールド追加（必須、ファイル存在確認あり）
2. **3082-3085行**: Core File、Symbol Fileフィールド追加
3. **3086行**: 詳細設定トグル追加
4. **3087-3092行**: 詳細設定フィールド追加
5. **3094行**: Createボタン追加

#### Step 3: ターゲット作成処理を理解する

CreateTarget メソッドの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3211-3241行：CreateTarget実装 |
| 3-2 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3140-3156行：GetTarget（ターゲット作成） |
| 3-3 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 3158-3193行：SetSymbolFile、SetCoreFile |

**主要処理フロー**:
- **3214-3216行**: フィールドバリデーション
- **3218-3220行**: ターゲット作成
- **3222-3238行**: シンボル/コア/リモートファイル設定
- **3240行**: 成功時にウィンドウを閉じる

### プログラム呼び出し階層図

```
ApplicationDelegate::MenuDelegateAction(eMenuID_TargetCreate)
    │
    └─ TargetCreateFormDelegate コンストラクタ
           │
           ├─ AddFileField() [Executable/Core/Symbol/Remote]
           ├─ AddBooleanField() [Show advanced]
           ├─ AddArchField() [Architecture]
           ├─ AddPlatformPluginField() [Platform]
           ├─ AddChoicesField() [Load Dependents]
           └─ AddAction("Create", CreateTarget)

CreateTarget(Window &window)
    │
    ├─ CheckFieldsValidity() [バリデーション]
    │
    ├─ GetTarget()
    │      └─ TargetList::CreateTarget()
    │
    ├─ SetSymbolFile()
    │      └─ Module::SetSymbolFileFileSpec()
    │
    ├─ SetCoreFile()
    │      └─ Target::CreateProcess()
    │            └─ Process::LoadCore()
    │
    ├─ SetRemoteFile()
    │      └─ Module::SetPlatformFileSpec()
    │
    └─ [成功] window.GetParent()->RemoveSubWindow()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Executableパス ────────────▶ TargetCreateFormDelegate       ─▶ Target作成
Core Fileパス                ::CreateTarget()
Symbol Fileパス

Platform選択 ──────────────▶ GetPlatformOptions()           ─▶ OptionGroupPlatform

Load Dependents ───────────▶ GetLoadDependentFiles()        ─▶ LoadDependentFiles enum

                             TargetList::CreateTarget()     ─▶ TargetSP

                             TargetList::SetSelectedTarget() ─▶ 選択ターゲット変更
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | TargetCreateFormDelegateの実装 |
| Target.h | `lldb/include/lldb/Target/Target.h` | ヘッダ | ターゲットクラス |
| TargetList.h | `lldb/include/lldb/Target/TargetList.h` | ヘッダ | ターゲットリストクラス |
| Module.h | `lldb/include/lldb/Core/Module.h` | ヘッダ | モジュールクラス |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダ | プロセスクラス |
