# 画面設計書 9-プロセスアタッチフォーム

## 概要

本ドキュメントは、LLDB Curses GUIにおけるプロセスアタッチフォームの画面設計を記載する。プロセスアタッチフォームは、実行中のプロセスにデバッガをアタッチするための設定フォームダイアログである。

### 本画面の処理概要

プロセスアタッチフォームは、既に実行中のプロセスにLLDBデバッガをアタッチするための設定を行うダイアログである。

**業務上の目的・背景**：デバッグの対象が既に実行中のプロセスである場合、そのプロセスにデバッガをアタッチする必要がある。このフォームでは、プロセスID（PID）またはプロセス名でアタッチ対象を指定できる。また、プロセスの起動を待機してからアタッチするオプションも提供し、サービスやデーモンのデバッグにも対応する。

**画面へのアクセス方法**：メニューバーから F3（Process） > Attach を選択することで表示される。

**主要な操作・処理内容**：
1. アタッチ方式の選択（名前/PID）
2. プロセスIDの入力（PID指定時）
3. プロセス名の入力（名前指定時）
4. プロセス起動待機オプション（名前指定時）
5. 既存プロセスを含めるオプション（待機時）
6. アタッチ後に続行するオプション
7. 詳細設定（プロセスプラグイン選択）
8. Attachボタンでアタッチ実行

**画面遷移**：
- この画面からの遷移先：メインウィンドウ（アタッチ成功時）、デタッチ/キル確認フォーム（既存プロセス実行中時）
- この画面への遷移元：メニューバー > Process > Attach

**権限による表示制御**：権限による表示制御は存在しない。ただし、実行中のプロセスがある場合はデタッチ/キル確認フォームが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | LLDB | 主機能 | ProcessAttachFormDelegateによる実行中プロセスへのアタッチ設定。PID/プロセス名/待機オプションの設定 |
| 8 | LLDB | 遷移先機能 | Attachボタンによるプロセスアタッチ。Target::Attachメソッドの呼び出し |

## 画面種別

フォームダイアログ（モーダル）

## URL/ルーティング

該当なし（CUI/TUIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Attach By | 入力 | 選択リスト | - | アタッチ方式（Name/PID） |
| PID | 入力 | 整数 | 条件付 | プロセスID（PID指定時は必須） |
| Process Name | 入力 | 文字列 | 条件付 | プロセス名（名前指定時は必須） |
| Continue once attached | 入力 | ブール | - | アタッチ後に続行するか |
| Wait for process to launch | 入力 | ブール | - | プロセス起動を待機するか |
| Include existing processes | 入力 | ブール | - | 既存プロセスも対象に含めるか（待機時） |
| Show advanced settings | 入力 | ブール | - | 詳細設定の表示/非表示 |
| Process Plugin | 入力 | 選択リスト | オプション | プロセスプラグイン選択（詳細） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| フォームタイトル | ダイアログ上部 | "Attach Process" |
| Attach Byフィールド | フォーム上部 | Name/PID選択 |
| PIDフィールド | Attach Byの下 | PID入力（PID選択時のみ表示） |
| Process Nameフィールド | Attach Byの下 | プロセス名入力（Name選択時のみ表示） |
| Continue once attachedチェックボックス | 基本設定 | アタッチ後続行フラグ |
| Wait for process to launchチェックボックス | 基本設定 | 起動待機フラグ（Name選択時のみ） |
| Include existing processesチェックボックス | 基本設定 | 既存プロセス含むフラグ（待機時のみ） |
| Show advanced settingsチェックボックス | 基本設定下 | 詳細設定トグル |
| Process Pluginフィールド | 詳細設定領域 | プラグイン選択（非表示可） |
| Attachボタン | フォーム下部 | アタッチ実行アクション |
| エラーメッセージ | フォーム下部 | バリデーション/実行エラー表示 |

## イベント仕様

### 1-Attach By 選択変更

フィールドの表示/非表示を切り替える。

- 処理：UpdateFieldsVisibility() が呼び出される（2932-2951行）
- Name選択：PIDフィールドを非表示、Process Name/Wait for/Include existingを表示
- PID選択：PIDフィールドを表示、その他を非表示

### 2-Wait for process to launch チェック変更

Include existing processes フィールドの表示/非表示を切り替える。

- チェックON：Include existing processes を表示
- チェックOFF：Include existing processes を非表示

### 3-Show advanced settings チェック変更

Process Plugin フィールドの表示/非表示を切り替える。

### 4-Attachボタン押下

プロセスにアタッチする。

- 処理：Attach(Window &window) が呼び出される
- フロー：
  1. 実行中のプロセスがある場合、デタッチ/キル確認フォームを表示
  2. フィールドのバリデーションチェック
  3. ProcessAttachInfo を構築
  4. Target::Attach() でアタッチ実行
  5. 成功時：Continue if requested、ダイアログを閉じる
  6. 失敗時：エラーメッセージを表示

## データベース更新仕様

該当なし（データベースは使用しない）

LLDB内部データ構造の更新：
| 操作 | 対象 | 概要 |
|-----|------|------|
| Target::Attach | Target | プロセスへのアタッチ |
| Process::Resume | Process | アタッチ後の続行（オプション） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 警告 | "There is a running process, either detach or kill it." | 実行中プロセス存在時 |
| MSG-002 | エラー | "{Status::AsCString()}" | アタッチ失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 実行中のプロセスがある | デタッチ/キル確認フォームを表示 |
| 指定したPIDのプロセスがない | エラーメッセージを表示 |
| アタッチ権限がない | エラーメッセージを表示 |
| プロセス名に一致するプロセスがない | 待機モードでない場合はエラー |

## 備考

- ProcessAttachFormDelegateクラスで実装
- FormDelegateを継承してフォーム機能を利用
- デフォルトプロセス名はターゲットの実行ファイル名から取得
- 実行中のプロセスがある場合、先にデタッチ/キルが必要
- ProcessAttachInfo構造体にアタッチ設定を格納

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ProcessAttachFormDelegateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 2909-2988行：ProcessAttachFormDelegateクラス定義前半 |

**読解のコツ**: Attach By 選択によって表示されるフィールドが動的に変わる。UpdateFieldsVisibilityで制御。

#### Step 2: フィールド初期化を理解する

コンストラクタでのフィールド設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 2910-2928行：コンストラクタ（フィールド追加） |

**主要処理フロー**:
1. **2913-2916行**: Attach By選択フィールド追加（Name/PID）
2. **2917-2919行**: PID、Process Nameフィールド追加
3. **2920-2924行**: チェックボックスフィールド追加
4. **2925行**: プロセスプラグインフィールド追加
5. **2927行**: Attachボタン追加

#### Step 3: 表示制御を理解する

UpdateFieldsVisibility メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 2932-2951行：UpdateFieldsVisibility実装 |

**主要処理フロー**:
- **2933-2940行**: Name選択時の表示制御
- **2941-2946行**: PID選択時の表示制御
- **2947-2950行**: 詳細設定の表示制御

#### Step 4: アタッチ処理を理解する

Attach メソッドの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | 2967-2988行：StopRunningProcess（既存プロセス処理） |

### プログラム呼び出し階層図

```
ApplicationDelegate::MenuDelegateAction(eMenuID_ProcessAttach)
    │
    └─ ProcessAttachFormDelegate コンストラクタ
           │
           ├─ AddChoicesField() [Attach By]
           ├─ AddIntegerField() [PID]
           ├─ AddTextField() [Process Name]
           ├─ AddBooleanField() [Continue/Wait/Include/Advanced]
           ├─ AddProcessPluginField() [Plugin]
           └─ AddAction("Attach", Attach)

Attach(Window &window)
    │
    ├─ StopRunningProcess()
    │      └─ [実行中プロセスあり] DetachOrKillProcessFormDelegate表示
    │
    ├─ CheckFieldsValidity() [バリデーション]
    │
    ├─ GetProcessAttachInfo()
    │      └─ ProcessAttachInfo構築
    │
    ├─ Target::Attach()
    │      └─ プロセスにアタッチ
    │
    ├─ [Continue] Process::Resume()
    │
    └─ [成功] window.GetParent()->RemoveSubWindow()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Attach By選択 ─────────────▶ UpdateFieldsVisibility()       ─▶ フィールド表示制御

PID / Process Name ─────────▶ ProcessAttachFormDelegate     ─▶ ProcessAttachInfo
Wait for / Include            ::GetProcessAttachInfo()

Continue once attached ─────▶ Attach()                       ┌─▶ Target::Attach()
                                                             └─▶ Process::Resume()

                             Target::Attach()               ─▶ ProcessSP
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOHandlerCursesGUI.cpp | `lldb/source/Core/IOHandlerCursesGUI.cpp` | ソース | ProcessAttachFormDelegateの実装 |
| ProcessAttachInfo.h | `lldb/include/lldb/Target/ProcessAttachInfo.h` | ヘッダ | アタッチ情報構造体 |
| Target.h | `lldb/include/lldb/Target/Target.h` | ヘッダ | ターゲットクラス（Attachメソッド） |
| Process.h | `lldb/include/lldb/Target/Process.h` | ヘッダ | プロセスクラス |
