---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-メインウィンドウ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **最小ターミナルサイズ**：具体的な最小サイズの根拠が不明
  2. **フォーカス順序**：循環順序の実装詳細要確認
  3. **レイアウト比率**：デフォルトの分割比率の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6312-6346行（ApplicationDelegateクラス定義、メニューID列挙型）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6348-6378行（WindowDelegateHandleChar実装）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6380-6403行（ヘルプテキストとキーヘルプ配列）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 119-262行（Point、Size、Rect構造体）
- E-05: `lldb/source/Core/IOHandlerCursesGUI.cpp` 574-624行（Windowクラス）
- E-06: `lldb/source/Core/IOHandlerCursesGUI.cpp` 315-330行（WindowDelegateインターフェース）
- E-07: `lldb/source/Core/IOHandlerCursesGUI.cpp` 89-98行（KEY_定数定義）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 1行目（メインウィンドウ情報）
- E-09: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 1行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ApplicationDelegateクラスでメインウィンドウが実装されている | E-01, E-08 | ○ |
| C-02 | WindowDelegateとMenuDelegateの両方を継承している | E-01 | ○ |
| C-03 | TABキーでSelectNextWindowAsActiveが呼ばれる | E-02 | ○ |
| C-04 | Shift+TABキーでSelectPreviousWindowAsActiveが呼ばれる | E-02 | ○ |
| C-05 | hキーでCreateHelpSubwindowが呼ばれる | E-02 | ○ |
| C-06 | ESCキーでeQuitApplicationが返される | E-02, E-07 | ○ |
| C-07 | F1〜F6キーでメニューにアクセスできる | E-03, E-09 | ○ |
| C-08 | メニューIDにはLLDB、Target、Process、Thread、View、Helpがある | E-01 | ○ |
| C-09 | Rectクラスにはレイアウト分割メソッドがある | E-04 | ○ |
| C-10 | Point、Size構造体で位置とサイズを管理 | E-04 | ○ |
| C-11 | Windowクラスはm_curr_active_window_idxでアクティブウィンドウを追跡 | E-05 | ○ |
| C-12 | guiコマンドでCurses GUIモードに入る | E-08 | ○ |
| C-13 | LLDB_ENABLE_CURSESが有効な場合のみ利用可能 | E-07 | ○ |
| C-14 | サブウィンドウにはソースビュー、変数ビュー、スレッドビューがある | E-08, E-09 | ○ |
| C-15 | レジスタビュー、ブレークポイントビューはトグル表示 | E-01, E-09 | ○ |
| C-16 | ヘルプダイアログへの遷移はhキー | E-02, E-09 | ○ |
| C-17 | ウィンドウの最小サイズが必要 | **根拠なし** | △ |
| C-18 | 機能No.8 LLDBが主機能として関連 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- ターミナルの最小サイズ要件についてコード内に明示的な定義が見つからない
  - 候補：ncurses の LINES/COLS マクロ / Window::GetSize() の戻り値チェック / Application 初期化コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから直接確認可能
- 1: 中リスク - 最小ターミナルサイズの記載は実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ApplicationDelegateクラスの実装を確認（6312行〜）
- [ ] WindowDelegateHandleCharのキー処理を確認（6357行〜）
- [ ] メニューID列挙型がすべて正しいか確認（6314行〜）
- [ ] 画面遷移図との整合性を確認
