---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-プロセス起動フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3256-3350行（ProcessLaunchFormDelegateクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3257-3301行（コンストラクタ）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3305-3350行（UpdateFieldsVisibility）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 10行目（プロセス起動フォーム情報）
- E-05: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 17-19行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProcessLaunchFormDelegateクラスで実装されている | E-01, E-04 | ○ |
| C-02 | FormDelegateを継承している | E-01 | ○ |
| C-03 | F3 > Process > Launchで表示される | E-05 | ○ |
| C-04 | Argumentsフィールドがある | E-02 | ○ |
| C-05 | Target Environment Variablesフィールドがある | E-02 | ○ |
| C-06 | Working Directoryフィールドがある | E-02 | ○ |
| C-07 | Stop at entry pointオプションがある | E-02 | ○ |
| C-08 | Detach on errorオプションがある | E-02 | ○ |
| C-09 | Disable ASLRオプションがある | E-02, E-06 | ○ |
| C-10 | Shell指定フィールドがある | E-02, E-06 | ○ |
| C-11 | 標準入出力のリダイレクト設定ができる | E-02, E-06 | ○ |
| C-12 | 継承環境変数の設定ができる | E-02 | ○ |
| C-13 | Show advanced settingsで詳細設定を切り替え | E-02, E-03 | ○ |
| C-14 | Disable Standard IOで標準入出力フィールドを切り替え | E-03 | ○ |
| C-15 | Launchボタンでプロセス起動 | E-02 | ○ |
| C-16 | Target::Launchでプロセス起動 | E-06 | ○ |
| C-17 | 実行中プロセスがある場合はデタッチ/キル確認フォームを表示 | E-05 | ○ |
| C-18 | フォームタイトルは"Launch Process" | E-01 | ○ |
| C-19 | 詳細設定は初期状態で非表示 | E-03 | ○ |
| C-20 | 機能No.8 LLDBが主機能、補助機能、遷移先機能として関連 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ProcessLaunchFormDelegateクラスの定義を確認（3256行〜）
- [ ] コンストラクタのフィールド追加を確認（3257行〜）
- [ ] UpdateFieldsVisibilityの表示制御を確認（3305行〜）
- [ ] 画面遷移図との整合性を確認
- [ ] 画面機能マッピングとの整合性を確認
